'use client';

import { Loader } from '@/components/others/CommonComponents';
import { CommentCard } from '@/components/reusables/Cards';
import { fetchEndpointData } from '@/components/utils/server-functions';
import { TCommentType } from '@/components/utils/types';
import { useQueryCustomWrapper } from '@/utils';
import { useQuery } from 'react-query';

export default function Comments() {
	const { isLoading, isError, data } = useQuery({
		queryFn: useQueryCustomWrapper<TCommentType[]>,
		queryKey: [
			`jobs-data`,
			{
				url: `comments`,
				qFunc: fetchEndpointData,
				options: {
					sort: 'createdAt:desc',
					populate: {
						job: { populate: ['ministry'] },
						createdBy: '',
						updatedBy: '',
						replies: {
							populate: ['user', 'createdBy', 'updatedBy', 'replies'],
						},
						user: '',
					},
				},
			},
		],
	});

	return (
		<div className='px-[10px] py-[10px] flex flex-col'>
			<div className='w-[90%] mx-auto'>
				<div className='flex flex-col mb-3 gap-5 w-full'>
					<h1 className='text-[20px] md:text-[25px] md:leading-[30px] font-bold text-body dark:text-[#F7F2FF] my-[10px]'>
						Job Comments
					</h1>
				</div>

				<div className='flex flex-col gap-[30px]'>
					{isLoading ? (
						<div className='md:col-span-6 rounded-[12px] bg-white shadow-sidebarShadow min-h-[500px] w-full flex items-center justify-center'>
							<Loader
								{...{
									title: 'Loading data...',
								}}
							/>
						</div>
					) : isError ? (
						<div className='md:col-span-6 rounded-[12px] bg-white shadow-sidebarShadow min-h-[500px] w-full flex items-center justify-center'>
							<Loader
								{...{
									title: 'Loading data...',
								}}
							/>
						</div>
					) : (
						data?.data?.map((commentData, index) => (
							<CommentCard key={index} {...commentData} />
						))
					)}
				</div>
			</div>
		</div>
	);
}
