import { TDataFormGraph } from '../jobs/types';

export type FinancialExpensesData = {
	expenses: TDataFormGraph[];
	networks: Network[];
	entries: ExpenseEntry[];
	organisation: Organisation;
	recent: Recent2[];
};

export type Network2 = {
	chartBg?: string;
	name: string;
	text: string;
	bg: string;
	id: number;

	createdAt: string;
	publishedAt: string;
	updatedAt: string;
};

export type Network = {
	network: Network2;
	expenses: Expense[];
};

export type Expense = {
	month: string;
	expense: number;
};

export type ExpenseEntry = {
	network: Network2;
	today: Today;
	thisWeek: ThisWeek;
	thisMonth: ThisMonth;
	lastMonth: LastMonth;
	campuses: Campuse[];
	recent: Recent[];
};

export type Today = {
	expense: number;
	entries: any[];
};

export type ThisWeek = {
	expense: number;
	entries: Entry2[];
};

export type Entry2 = {
	campus: string;
	expense: number;
};

export type ThisMonth = {
	expense: number;
	entries: Entry3[];
};

export type Entry3 = {
	campus: string;
	expense: number;
};

export type LastMonth = {
	expense: number;
	entries: Entry4[];
};

export type Entry4 = {
	campus: string;
	expense: number;
};

export type Campuse = {
	name: string;
	expenses: Expense2[];
};

export type Expense2 = {
	month: string;
	expense: number;
};

export type Recent = {
	date: string;
	id: number;
	amount: number;
	description: string;
	campus: Campus;
	appovedBy: AppovedBy;
	network: Network2;
};

export type Campus = {
	id: number;
	name: string;
	location: string;
	network: Network2;
};

export type AppovedBy = {
	id: number;
	name: string;
	gender: string;
	dateOfBirth: string;
	spouse: string;
	maritalStatus: string;
	pastoralRole: string;
	isStaff: boolean;
	isPastoralMember: boolean;
	staffRole: string;
};

export type Recent2 = {
	id: number;
	amount: number;
	description: string;
	date: string;
	campus: Campus2;
	appovedBy: AppovedBy2;
	network: Network5;
};

export type Campus2 = {
	id: number;
	name: string;
	location: string;
	network: Network4;
};

export type Network4 = {
	id: number;
	name: string;
	bg: string;
	text: string;
};

export type AppovedBy2 = {
	id: number;
	name: string;
	gender: string;
	dateOfBirth: string;
	spouse: string;
	maritalStatus: string;
	pastoralRole: string;
	isStaff: boolean;
	isPastoralMember: boolean;
	staffRole: string;
};

export type Network5 = {
	id: number;
	name: string;
	bg: string;
	text: string;
};

//organisation
export type Organisation = {
	allocations: Allocations;
	expenses: NetExpenses;
	balance: Balance;
};

type Allocations = {
	today: number;
	thisWeek: number;
	thisMonth: number;
	lastMonth: number;
	trend: number;
};

type NetExpenses = {
	today: number;
	thisWeek: number;
	thisMonth: number;
	lastMonth: number;
	trend: number;
};

type Balance = {
	remainingAmount: number;
	remainingPercentage: number;
	balanceTrend: number;
	lastMonthBalance: number;
	thisMonthBalance: number;
};
