'use client';

import { Loader } from '@/components/others/CommonComponents';
import { DepartmentCard } from '@/components/reusables/Cards';
import { fetchEndpointData } from '@/components/utils/server-functions';
import { TMinistry } from '@/components/utils/types';
import { useQueryCustomWrapper } from '@/utils';
import { useQuery } from 'react-query';

export default function () {
	const {
		isLoading: isMinistryLoading,
		isError: isMinistryError,
		data,
	} = useQuery({
		queryFn: useQueryCustomWrapper<TMinistry[]>,
		queryKey: [
			`ministry-data`,
			{
				url: `ministries`,
				qFunc: fetchEndpointData,
				options: {
					fields: ['name'],
				},
			},
		],
	});

	return (
		<div className='my-[10px] px-[10px]'>
			<div className='font-bold text-[25px] leading-[30px] text-body my-[6px]'>
				County Departments
			</div>
			<div className='grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 rounded-[6px] mt-[16px] h-[98%] text-black  gap-[20px] justify-between'>
				{isMinistryLoading ? (
					<div className='w-full rounded flex'>
						<Loader />
					</div>
				) : isMinistryError ? (
					<div className='w-full rounded flex'>
						<Loader {...{ title: 'Error loading data' }} />
					</div>
				) : (
					<>
						{data?.data.map((category, index) => (
							<div key={index}>
								<DepartmentCard {...category} />
							</div>
						))}
					</>
				)}
			</div>
		</div>
	);
}
