'use client';

import { CreateUpdateJob } from '@/components/jobs';
import { Loader } from '@/components/others/CommonComponents';
import { fetchEndpointData } from '@/components/utils/server-functions';
import { TJobTypes, TMinistry } from '@/components/utils/types';
import { useQueryCustomWrapper } from '@/utils';
import { useQuery } from 'react-query';

export default function Page() {
	const {
		isLoading: isMinistryLoading,
		isError: isMinistryError,
		data: ministries,
	} = useQuery({
		queryFn: useQueryCustomWrapper<TMinistry[]>,
		queryKey: [
			`ministry-data`,
			{
				url: `ministries`,
				qFunc: fetchEndpointData,
			},
		],
	});

	const {
		isLoading: isJobtypeLoading,
		isError: isJobTypeError,
		data: jobTypes,
	} = useQuery({
		queryFn: useQueryCustomWrapper<TJobTypes[]>,
		queryKey: [
			`jobtype-data`,
			{
				url: `job-types`,
				qFunc: fetchEndpointData,
			},
		],
	});

	return (
		<div className='w-[96%] p-[20px] mb-[100px] bg-white border py-[16px] mx-auto shadow-applicantBoxDetailsShadow rounded-[8px]'>
			{isMinistryLoading || isJobtypeLoading ? (
				<div className='w-full h-full'>
					<Loader />
				</div>
			) : isJobTypeError || isMinistryError ? (
				<div className='w-full h-full'>
					<Loader {...{ title: 'Error loading data' }} />
				</div>
			) : (
				<CreateUpdateJob
					{...{
						title: 'Create a new job posting',
						jobTypes: jobTypes?.data ?? [],
						ministries: ministries?.data ?? [],
						successBtn: {
							subDetails: { method: 'POST', url: 'jobs' },
							text: 'Post Job',
						},
					}}
				/>
			)}
		</div>
	);
}
