export type NetworkLists = {
	name: string;
	summary: NetworkSummary;
};

export type Attendance = TDataFormGraph;

export type NetworkSummary = {
	network: Network;
	attendances: Attendance[];
	members: Members;
	staff: Staff;
	campuses: Campuses;
	giving: Giving;
	expenses: Expenses;
	allocation: Allocation;
	discipleshipGroups: number;
};

export type Network = {
	name: string;
	colors: Colors;
	pastor: Pastor;
};

export type Colors = {
	id: number;
	bg: string;
	text: string;
};

export type Pastor = {
	id: number;
	name: string;
	gender: string;
	dateOfBirth: string;
	spouse: string;
	maritalStatus: string;
	pastoralRole: string;
	isStaff: boolean;
	isPastoralMember: boolean;
	staffRole: string;
	createdAt: string;
	updatedAt: string;
	publishedAt: string;
};
export type TDataFormGraph = {
	month: string;
	totals: number;
};

export type Members = {
	thisMonth: number;
	lastMonth: number;
	trend: number;
	total: number;
};

export type Staff = {
	total: number;
	trend: number;
	thisMonth: number;
};

export type Campuses = {
	total: number;
};

export type Giving = {
	thisMonth: number;
	lastMonth: number;
	today: number;
	thisWeek: number;
	trend: number;
};

export type Expenses = {
	thisMonth: number;
	lastMonth: number;
	trend: number;
	percentageOfAllocation: number;
	today: number;
	thisWeek: number;
};

export type Allocation = {
	thisMonth: number;
	lastMonth: number;
	trend: number;
};
