import dynamic from 'next/dynamic';

import { Loader } from '@/components/others/CommonComponents';
import SideBar from '@/components/reusables/SideBar';
import Container from '@/components/container';
import { Metadata } from 'next';
import {
	PLATFORM_PREFIX_NAME,
	PLATFORM_SUFFIX_NAME,
} from '@/components/utils/constants';

const Header = dynamic(() => import('@/components/reusables/Header'), {
	ssr: false,
	loading: () => (
		<div className='dark:text-white w-[98%] h-[60px] selection:bg-inherit rounded-[12px] bg-sidebar-bg-light dark:bg-sidebar-bg text-body-bg dark:text-foundation flex items-center justify-self-center py-[10px] ml-4 mr-2'>
			<Loader
				{...{
					title: 'Loading...',
				}}
			/>
		</div>
	),
});

export const metadata: Metadata = {
	title: `${PLATFORM_PREFIX_NAME} | Dashboard`,
	description: `${PLATFORM_PREFIX_NAME} ${PLATFORM_SUFFIX_NAME} Dashboard`,
};

export default function RootLayout({
	children,
}: {
	children: React.ReactNode;
}) {
	return (
		<Container>
			<div className='flex h-full'>
				{/* side bar section  */}
				{/* flex-[1.8074] */}
				<div className='overflow-y-auto h-full hidden sm:block flex-[1.2]'>
					<SideBar />
				</div>
				{/* end of sidebar section  */}
				{/* main window section  */}
				<div className='flex-[6] flex overflow-y-auto flex-col h-full sm:col-span-6 bg-small-card-bg-light dark:bg-body-bg text-sidebar-bg dark:text-white'>
					{/* header section */}
					<div className='flex justify-center z-10 sticky top-[0px] right-0 w-[98%] bg-white py-[12px] border-b-[1px] border-gray-200 my-[20px] mx-auto rounded-[12px]'>
						<Header />
					</div>
					{/* end of header section  */}

					{/* dynamic content section */}
					<div className='h-[80dvh] max-h-[90dvh]'>{children}</div>
					{/* end of dynamic content section  */}
				</div>
				{/* end of main body section  */}
			</div>
		</Container>
	);
}
