'use client';

import { Loader } from '@/components/others/CommonComponents';
import { fetchEndpointData } from '@/components/utils/server-functions';
import { TUSER } from '@/components/utils/types';
import { useQueryCustomWrapper } from '@/utils';
import dynamic from 'next/dynamic';
import { useQuery } from 'react-query';

const ProfileWrapper = dynamic(
	() =>
		import('@/components/others/CommonComponents').then(
			(mod) => mod.ProfileWrapper
		),

	{
		ssr: false,
		loading: () => (
			<div className='dark:text-white w-[98%] h-[60px] selection:bg-inherit rounded-[12px] bg-sidebar-bg-light dark:bg-sidebar-bg text-body-bg dark:text-foundation flex items-center justify-self-center py-[10px] ml-4 mr-2'>
				<Loader />
			</div>
		),
	}
);

const Profile = () => {
	const { isLoading, isError, data, refetch } = useQuery({
		queryFn: useQueryCustomWrapper<TUSER<string>>,
		queryKey: [
			`user-data`,
			{
				url: `auth/me`,
				qFunc: fetchEndpointData,
				options: {
					populate: { ministry: true },
				},
			},
		],
	});

	return (
		<div className=' h-full m-[10px] flex flex-col gap-[40px] px-[16px]'>
			{isLoading ? (
				<div className='w-full h-[500px] bg-sidebar-bg-light dark:bg-small-card-bg'>
					<Loader />
				</div>
			) : isError ? (
				<div className='w-full h-[500px] bg-sidebar-bg-light dark:bg-small-card-bg'>
					<Loader
						{...{
							title: 'Error loading data',
						}}
					/>
				</div>
			) : (
				<ProfileWrapper {...{ data, refetch }} />
			)}
		</div>
	);
};

export default Profile;
