'use client';

import { fetchEndpointData } from '@/components/utils/server-functions';
import { CreateEditUser } from '@/components/jobs';
import { Loader } from '@/components/others/CommonComponents';
import { useQueryCustomWrapper } from '@/utils';
import { Role, TMinistry } from '@/components/utils/types';
import { useQuery } from 'react-query';

const Profile = () => {
	const {
		isLoading: isMinistryLoading,
		isError: isMinistryError,
		data: ministries,
	} = useQuery({
		queryFn: useQueryCustomWrapper<TMinistry[]>,
		queryKey: [
			`ministry-data`,
			{
				url: `ministries`,
				qFunc: fetchEndpointData,
			},
		],
	});

	const {
		isLoading: isRolesLoading,
		isError: isRolesError,
		data: roles,
	} = useQuery({
		queryFn: useQueryCustomWrapper<Role[]>,
		queryKey: [
			`user-roles`,
			{
				url: `auth/roles`,
				qFunc: fetchEndpointData,
			},
		],
	});

	return (
		<div className=' m-[10px] flex flex-col gap-[40px] justify-center items-center'>
			{isMinistryLoading || isRolesLoading ? (
				<div className='w-full h-full'>
					<Loader />
				</div>
			) : isMinistryError || isRolesError ? (
				<div className='w-full h-full'>
					<Loader {...{ title: 'Error loading data' }} />
				</div>
			) : (
				<CreateEditUser
					{...{
						title: 'Create a new job posting',
						ministries: ministries?.data ?? [],
						roles:
							roles?.data?.map(({ name, ...rest }) => ({
								...rest,
								// overwrite the id field to point to the role name
								id: name,
								name,
							})) ?? [],
						successBtn: {
							subDetails: { method: 'POST', url: 'auth/register' },
							text: 'Create User',
						},
					}}
				/>
			)}
		</div>
	);
};

export default Profile;
