'use client';

import { BASE_URL } from '@/components/utils/constants';
import { ArrowLeftIcon } from '@radix-ui/react-icons';
import { EmailIcon } from '@/components/icons';
import { useRouter } from 'next/navigation';
import Image from 'next/image';
import Link from 'next/link';

export default function () {
	const router = useRouter();

	return (
		<div className=' h-full flex flex-col pl-[15px] pr-[15px] pt-[16px] pb-[33px] gap-y-[32px] md:gap-y-0 md:gap-[20px] md:px-[16px]'>
			<div className='w-[96%] p-[20px] bg-white border py-[16px] mx-auto shadow-applicantBoxDetailsShadow rounded-[8px]'>
				<div className='flex flex-col justify-center items-center gap-[16px] my-[6px]'>
					<div className='w-[76%]'>
						<Image
							src={'/images/others/support-banner.svg'}
							alt='Support banner'
							className='w-full'
							width={706}
							height={349}
						/>
					</div>

					<div className='flex items-center flex-col'>
						<p className='font-bold text-[30px] leading-[36px] text-center'>
							Having a challenge? Worry no more!
						</p>
						<p className='text-gray-body-text font-normal leading-[24px] text-[16px] text-center my-[6px]'>
							We are here to support you in achieving your goals. Send us an
							email and we’ll get to it as fast as possible.
						</p>
					</div>

					<div className='w-full flex justify-center gap-[30px] my-[8px]'>
						<div
							className='border-border-color w-fit h-fit flex gap-[10px] rounded-[8px] px-[16px] py-[10px] border items-center justify-center selection:bg-inherit'
							role='button'
							onClick={(e) => router.push(`${BASE_URL}`)}>
							<ArrowLeftIcon width={24} height={24} />
							<p className='text-black w-fit'>Back to Dashboard</p>
						</div>

						<Link
							className='bg-dev-accent w-fit h-fit flex gap-[10px] rounded-[8px] px-[16px] py-[10px] border items-center justify-center selection:bg-inherit'
							role='button'
							href={'mailto:support@kitui.go.ke'}>
							<EmailIcon
								{...{
									svgElementClassName: 'stroke-white',
									applyToSvgEl: false,
									styles: {
										width: '24px',
										height: '24px',
									},
								}}
							/>
							<p className='text-white w-fit'>Contact Support</p>
						</Link>
					</div>
				</div>
			</div>
		</div>
	);
}
