import { Metadata } from 'next';

import AuthScreen from '@/components/auth/Auth';
import {
	PLATFORM_PREFIX_NAME,
	PLATFORM_SUFFIX_NAME,
} from '@/components/utils/constants';

export const metadata: Metadata = {
	title: `${PLATFORM_PREFIX_NAME} | Login`,
	description: `${PLATFORM_PREFIX_NAME} ${PLATFORM_SUFFIX_NAME} login page`,
};

export default function Home() {
	return (
		<div className="w-full h-screen bg-cover bg-no-repeat bg-[url('/images/others/login.svg')]">
			<AuthScreen />
		</div>
	);
}
