import { Metadata } from 'next';

import {
	PLATFORM_PREFIX_NAME,
	PLATFORM_SUFFIX_NAME,
} from '@/components/utils/constants';
import { ResetPassword } from '@/components/auth/Auth';

export const metadata: Metadata = {
	title: `${PLATFORM_PREFIX_NAME} | Reset password`,
	description: `${PLATFORM_PREFIX_NAME} ${PLATFORM_SUFFIX_NAME} Reset password`,
};

export default function Home() {
	return (
		<div className="w-full h-screen bg-[url('/images/others/login.svg')]">
			<ResetPassword />
		</div>
	);
}
