import 'react-quill/dist/quill.snow.css';

import { useRef } from 'react';
import ReactQuill from 'react-quill';

const RichTexEditor = ({
	onChangeHandler,
	defaultValue = '',
}: {
	onChangeHandler: (data: string) => void;
	defaultValue?: string;
}) => {
	const modules = {
		toolbar: [
			[{ header: [1, 2, 3, 4, false] }],
			['bold', 'italic', 'underline', 'strike', 'blockquote'],
			[
				{ list: 'ordered' },
				{ list: 'bullet' },
				{ indent: '-1' },
				{ indent: '+1' },
			],
			['link', 'image'],
			['clean'],
		],
	};

	const formats = [
		'header',
		'bold',
		'italic',
		'underline',
		'strike',
		'blockquote',
		'list',
		'bullet',
		'indent',
		'link',
		'image',
	];

	const editorRef = useRef<ReactQuill>(null);

	const handleChange = (content: string) => {
		if (editorRef.current) {
			const editor = editorRef.current.getEditor();
			onChangeHandler(content);
		}
	};

	return (
		<div className='w-full h-fit'>
			<ReactQuill
				{...{
					style: { height: '500px', width: '100%' },
					onChange: handleChange,
					value: defaultValue,
					className: 'w-full',
					ref: editorRef,
					theme: 'snow',
					formats,
					modules,
				}}
			/>
		</div>
	);
};
export default RichTexEditor;
