import { TComponentBasicProps } from '../utils/types';

export const LocationIcon = ({
	svgElementClassName,
	className,
	styles,
}: TComponentBasicProps) => (
	<div
		{...{
			className,
			style: styles,
		}}>
		<svg viewBox='0 0 25 24' fill='none' xmlns='http://www.w3.org/2000/svg'>
			<path
				d='M20 9.75C20 16.5 12.5 21.75 12.5 21.75C12.5 21.75 5 16.5 5 9.75C5 7.76088 5.79018 5.85322 7.1967 4.4467C8.60322 3.04018 10.5109 2.25 12.5 2.25C14.4891 2.25 16.3968 3.04018 17.8033 4.4467C19.2098 5.85322 20 7.76088 20 9.75Z'
				{...{
					className: svgElementClassName,
				}}
				strokeWidth='1.5'
				strokeLinecap='round'
				strokeLinejoin='round'
			/>
			<path
				d='M12.5 14.4404C14.7091 14.4404 16.5 12.6496 16.5 10.4404C16.5 8.23129 14.7091 6.44043 12.5 6.44043C10.2909 6.44043 8.5 8.23129 8.5 10.4404C8.5 12.6496 10.2909 14.4404 12.5 14.4404Z'
				{...{
					className: svgElementClassName,
				}}
				strokeWidth='1.5'
				strokeLinecap='round'
				strokeLinejoin='round'
			/>
		</svg>
	</div>
);

export const HomeIcon = ({
	svgElementClassName,
	className,
	styles,
}: TComponentBasicProps) => (
	<div
		{...{
			style: styles,
			className,
		}}>
		<svg viewBox='0 0 24 24' fill='none' xmlns='http://www.w3.org/2000/svg'>
			<path
				d='M9.15722 20.7714V17.7047C9.1572 16.9246 9.79312 16.2908 10.581 16.2856H13.4671C14.2587 16.2856 14.9005 16.9209 14.9005 17.7047V17.7047V20.7809C14.9003 21.4432 15.4343 21.9845 16.103 22H18.0271C19.9451 22 21.5 20.4607 21.5 18.5618V18.5618V9.83784C21.4898 9.09083 21.1355 8.38935 20.538 7.93303L13.9577 2.6853C12.8049 1.77157 11.1662 1.77157 10.0134 2.6853L3.46203 7.94256C2.86226 8.39702 2.50739 9.09967 2.5 9.84736V18.5618C2.5 20.4607 4.05488 22 5.97291 22H7.89696C8.58235 22 9.13797 21.4499 9.13797 20.7714V20.7714'
				strokeWidth='1.5'
				strokeLinecap='round'
				strokeLinejoin='round'
				{...{
					className: svgElementClassName,
				}}
			/>
		</svg>
	</div>
);

export const NetworkIcon = ({
	svgElementClassName,
	className,
	styles,
}: TComponentBasicProps) => (
	<div
		{...{
			className,
			style: styles,
		}}>
		<svg
			width='25'
			height='25'
			viewBox='0 0 25 25'
			fill='none'
			xmlns='http://www.w3.org/2000/svg'>
			<g clipPath='url(#clip0_218_38)'>
				<path
					d='M6.5 15.5596C8.15685 15.5596 9.5 14.2164 9.5 12.5596C9.5 10.9027 8.15685 9.55957 6.5 9.55957C4.84315 9.55957 3.5 10.9027 3.5 12.5596C3.5 14.2164 4.84315 15.5596 6.5 15.5596Z'
					{...{
						className: svgElementClassName,
					}}
					strokeWidth='1.5'
					strokeLinecap='round'
					strokeLinejoin='round'
				/>
				<path
					d='M17 22.3096C18.6569 22.3096 20 20.9664 20 19.3096C20 17.6527 18.6569 16.3096 17 16.3096C15.3431 16.3096 14 17.6527 14 19.3096C14 20.9664 15.3431 22.3096 17 22.3096Z'
					{...{
						className: svgElementClassName,
					}}
					strokeWidth='1.5'
					strokeLinecap='round'
					strokeLinejoin='round'
				/>
				<path
					d='M17 8.80957C18.6569 8.80957 20 7.46642 20 5.80957C20 4.15272 18.6569 2.80957 17 2.80957C15.3431 2.80957 14 4.15272 14 5.80957C14 7.46642 15.3431 8.80957 17 8.80957Z'
					{...{
						className: svgElementClassName,
					}}
					strokeWidth='1.5'
					strokeLinecap='round'
					strokeLinejoin='round'
				/>
				<path
					d='M14.4772 7.4314L9.02283 10.9376'
					{...{
						className: svgElementClassName,
					}}
					strokeWidth='1.5'
					strokeLinecap='round'
					strokeLinejoin='round'
				/>
				<path
					d='M9.02283 14.1814L14.4772 17.6876'
					{...{
						className: svgElementClassName,
					}}
					strokeWidth='1.5'
					strokeLinecap='round'
					strokeLinejoin='round'
				/>
			</g>
			<defs>
				<clipPath id='clip0_218_38'>
					<rect
						width='24'
						height='24'
						fill='white'
						transform='translate(0.5 0.55957)'
					/>
				</clipPath>
			</defs>
		</svg>
	</div>
);

export const AccountsIcon = ({
	svgElementClassName,
	className,
	styles,
}: TComponentBasicProps) => (
	<div
		{...{
			className,
			style: styles,
		}}>
		<svg
			width='21'
			height='20'
			viewBox='0 0 21 20'
			fill='none'
			xmlns='http://www.w3.org/2000/svg'>
			<g id='Wallet'>
				<path
					id='Stroke 1'
					d='M20.1389 12.3957H16.0906C14.6042 12.3948 13.3993 11.1909 13.3984 9.70446C13.3984 8.21801 14.6042 7.01409 16.0906 7.01318H20.1389'
					{...{ className: svgElementClassName }}
					strokeWidth='1.5'
					strokeLinecap='round'
					strokeLinejoin='round'
				/>
				<path
					id='Stroke 3'
					d='M16.5486 9.64294H16.2369'
					{...{ className: svgElementClassName }}
					strokeWidth='1.5'
					strokeLinecap='round'
					strokeLinejoin='round'
				/>
				<path
					id='Stroke 5'
					fillRule='evenodd'
					clipRule='evenodd'
					d='M6.24766 1H14.8911C17.7892 1 20.1388 3.34951 20.1388 6.24766V13.4247C20.1388 16.3229 17.7892 18.6724 14.8911 18.6724H6.24766C3.34951 18.6724 1 16.3229 1 13.4247V6.24766C1 3.34951 3.34951 1 6.24766 1Z'
					{...{ className: svgElementClassName }}
					strokeWidth='1.5'
					strokeLinecap='round'
					strokeLinejoin='round'
				/>
				<path
					id='Stroke 7'
					d='M5.53558 5.5382H10.9345'
					{...{ className: svgElementClassName }}
					strokeWidth='1.5'
					strokeLinecap='round'
					strokeLinejoin='round'
				/>
			</g>
		</svg>
	</div>
);

export const StaffIcon = ({
	svgElementClassName,
	applyToSvgEl = false,
	className,
	styles,
}: TComponentBasicProps) => (
	<div
		{...{
			style: styles,
			className,
		}}>
		<svg
			viewBox='0 0 25 25'
			{...(applyToSvgEl
				? {
						className: svgElementClassName,
				  }
				: {
						className: 'fill-none',
				  })}
			xmlns='http://www.w3.org/2000/svg'>
			<circle
				cx='12.0789'
				cy='7.8376'
				r='4.77803'
				{...{
					className: svgElementClassName,
				}}
				strokeLinecap='round'
				strokeLinejoin='round'
				strokeWidth='1.5'
			/>
			<path
				fillRule='evenodd'
				clipRule='evenodd'
				d='M4.50002 19.2609C4.49873 18.925 4.57385 18.5932 4.7197 18.2906C5.17736 17.3753 6.46798 16.8902 7.53892 16.6705C8.31128 16.5057 9.09431 16.3956 9.88217 16.341C11.3408 16.2128 12.8079 16.2128 14.2666 16.341C15.0544 16.3962 15.8374 16.5063 16.6099 16.6705C17.6808 16.8902 18.9714 17.3295 19.4291 18.2906C19.7224 18.9074 19.7224 19.6235 19.4291 20.2403C18.9714 21.2014 17.6808 21.6407 16.6099 21.8513C15.8384 22.0229 15.0551 22.1361 14.2666 22.1899C13.0794 22.2906 11.8866 22.3089 10.6968 22.2449C10.4222 22.2449 10.1568 22.2449 9.88217 22.1899C9.09663 22.1368 8.31632 22.0236 7.54807 21.8513C6.46798 21.6407 5.18652 21.2014 4.7197 20.2403C4.5746 19.9342 4.49955 19.5996 4.50002 19.2609Z'
				{...{
					className: svgElementClassName,
				}}
				strokeWidth='1.5'
				strokeLinecap='round'
				strokeLinejoin='round'
			/>
		</svg>
	</div>
);

export const MessageIcon = ({
	svgElementClassName,
	applyToSvgEl,
	className,
	styles,
}: TComponentBasicProps) => (
	<div
		{...{
			style: styles,
			className,
		}}>
		<svg
			viewBox='0 0 25 25'
			{...(applyToSvgEl
				? {
						className: svgElementClassName,
				  }
				: {
						className: 'fill-none',
				  })}
			xmlns='http://www.w3.org/2000/svg'>
			<path
				d='M18.75 0.5H2.25003C1.8522 0.5 1.47067 0.658035 1.18937 0.93934C0.908061 1.22064 0.750026 1.60218 0.750026 2V17C0.748331 17.2859 0.829157 17.5662 0.982808 17.8074C1.13646 18.0485 1.35641 18.2401 1.61628 18.3594C1.81486 18.4516 2.03109 18.4996 2.25003 18.5C2.60215 18.4992 2.9426 18.3736 3.21096 18.1456C3.21544 18.1427 3.21953 18.1392 3.22315 18.1353L6.2344 15.5H18.75C19.1479 15.5 19.5294 15.342 19.8107 15.0607C20.092 14.7794 20.25 14.3978 20.25 14V2C20.25 1.60218 20.092 1.22064 19.8107 0.93934C19.5294 0.658035 19.1479 0.5 18.75 0.5ZM18.75 14H6.2344C5.88117 13.9998 5.53922 14.1243 5.26878 14.3516L5.25753 14.3619L2.25003 17V2H18.75V14ZM6.75003 6.5C6.75003 6.30109 6.82904 6.11032 6.9697 5.96967C7.11035 5.82902 7.30111 5.75 7.50003 5.75H13.5C13.6989 5.75 13.8897 5.82902 14.0304 5.96967C14.171 6.11032 14.25 6.30109 14.25 6.5C14.25 6.69891 14.171 6.88968 14.0304 7.03033C13.8897 7.17098 13.6989 7.25 13.5 7.25H7.50003C7.30111 7.25 7.11035 7.17098 6.9697 7.03033C6.82904 6.88968 6.75003 6.69891 6.75003 6.5ZM6.75003 9.5C6.75003 9.30109 6.82904 9.11032 6.9697 8.96967C7.11035 8.82902 7.30111 8.75 7.50003 8.75H13.5C13.6989 8.75 13.8897 8.82902 14.0304 8.96967C14.171 9.11032 14.25 9.30109 14.25 9.5C14.25 9.69891 14.171 9.88968 14.0304 10.0303C13.8897 10.171 13.6989 10.25 13.5 10.25H7.50003C7.30111 10.25 7.11035 10.171 6.9697 10.0303C6.82904 9.88968 6.75003 9.69891 6.75003 9.5Z'
				{...{
					className: `fill-sidebar-bg ${
						svgElementClassName == 'stroke-sidebar-bg'
					}  ? "fill-sidebar-bg": "fill-white"`,
				}}
				strokeLinecap='round'
				strokeLinejoin='round'
				clipRule='evenodd'
				fillRule='evenodd'
			/>
		</svg>
	</div>
);

export const ReportsIcon = ({
	svgElementClassName,
	className,
	styles,
}: TComponentBasicProps) => (
	<div
		{...{
			className,
			style: styles,
		}}>
		<svg
			width='25'
			height='25'
			viewBox='0 0 25 25'
			fill='none'
			xmlns='http://www.w3.org/2000/svg'>
			<path
				fillRule='evenodd'
				clipRule='evenodd'
				d='M22.0241 10.3125C21.385 6.37914 18.044 3.4529 14.0607 3.33771C13.8713 3.33028 13.6867 3.39847 13.5477 3.52724C13.4086 3.65602 13.3264 3.8348 13.3193 4.02421V4.02421V4.08828L13.7678 10.7977C13.7972 11.2493 14.1855 11.5926 14.6374 11.5665L21.365 11.118C21.5546 11.104 21.7308 11.015 21.8545 10.8707C21.9782 10.7263 22.0392 10.5386 22.0241 10.3491V10.3125Z'
				strokeWidth='1.5'
				strokeLinecap='round'
				strokeLinejoin='round'
				{...{
					className: svgElementClassName,
				}}
			/>
			<path
				d='M9.40163 7.32858C9.82959 7.22959 10.2675 7.44856 10.4451 7.85032C10.4916 7.94482 10.5196 8.04735 10.5275 8.15238C10.619 9.45215 10.8112 12.2988 10.9211 13.8366C10.9398 14.1136 11.0682 14.3717 11.2778 14.5538C11.4874 14.7359 11.7609 14.827 12.0378 14.8068V14.8068L17.6854 14.459C17.9375 14.4439 18.1847 14.5336 18.3684 14.7069C18.5522 14.8802 18.6561 15.1218 18.6556 15.3743V15.3743C18.4268 18.7847 15.9765 21.6358 12.6393 22.3748C9.30214 23.1138 5.8773 21.5638 4.23001 18.5689C3.73826 17.7069 3.42684 16.754 3.31467 15.7679C3.26672 15.4653 3.24833 15.1588 3.25975 14.8526C3.26947 11.2106 5.82726 8.07254 9.39248 7.32858'
				strokeWidth='1.5'
				strokeLinecap='round'
				strokeLinejoin='round'
				{...{
					className: svgElementClassName,
				}}
			/>
		</svg>
	</div>
);

export const ArrowRightIcon = ({
	svgElementClassName,
	applyToSvgEl = false,
	className,
	styles,
}: TComponentBasicProps) => (
	<div
		{...{
			style: styles,
			className,
		}}>
		<svg
			viewBox='0 0 20 20'
			{...(applyToSvgEl
				? {
						className: svgElementClassName,
				  }
				: {
						className: 'fill-none',
				  })}
			xmlns='http://www.w3.org/2000/svg'>
			<path
				d='M4.16663 10H15.8333'
				{...{
					className: svgElementClassName,
				}}
				strokeLinecap='round'
				strokeLinejoin='round'
				strokeWidth='1.5'
			/>
			<path
				d='M10 4.1665L15.8333 9.99984L10 15.8332'
				{...{
					className: svgElementClassName,
				}}
				strokeWidth='1.5'
				strokeLinecap='round'
				strokeLinejoin='round'
			/>
		</svg>
	</div>
);

export const ArrowDownIcon = ({
	svgElementClassName,
	className,
	styles,
}: TComponentBasicProps) => (
	<div
		{...{
			style: styles,
			className,
		}}>
		<svg
			width='19'
			height='18'
			viewBox='0 0 19 18'
			fill='none'
			xmlns='http://www.w3.org/2000/svg'>
			<path
				d='M14.75 6.375L9.5 11.625L4.25 6.375'
				{...{
					className: svgElementClassName,
				}}
				strokeWidth='1.5'
				strokeLinecap='round'
				strokeLinejoin='round'
			/>
		</svg>
	</div>
);

export const CardWaveIcon = ({
	svgElementClassName,
	className,
	styles,
}: TComponentBasicProps) => (
	<div
		{...{
			style: styles,
			className,
		}}>
		<svg
			// width='101'
			// height='61'
			viewBox='0 0 101 61'
			fill='none'
			xmlns='http://www.w3.org/2000/svg'>
			<path
				d='M55.6531 26.8096C20.7497 26.8096 4.00794 49.3096 0 60.5596H101V0.55957C100.427 9.30957 90.5565 26.8096 55.6531 26.8096Z'
				{...{
					className: svgElementClassName,
				}}
			/>
		</svg>
	</div>
);

export const FunnelIcon = ({
	svgElementClassName,
	applyToSvgEl = false,
	className,
	styles,
}: TComponentBasicProps) => (
	<div
		{...{
			style: styles,
			className,
		}}>
		<svg
			viewBox='0 0 20 20'
			{...(applyToSvgEl
				? {
						className: svgElementClassName,
				  }
				: {
						className: 'fill-none',
				  })}
			xmlns='http://www.w3.org/2000/svg'>
			<path
				d='M5 10H15M2.5 5H17.5M7.5 15H12.5'
				{...{
					className: svgElementClassName,
				}}
				strokeLinejoin='round'
				strokeLinecap='round'
				strokeWidth='1.67'
			/>
		</svg>
	</div>
);

export const SortIcon = ({
	svgElementClassName,
	applyToSvgEl,
	className,
	styles,
}: TComponentBasicProps) => (
	<div
		{...{
			style: styles,
			className,
		}}>
		<svg
			{...(applyToSvgEl
				? {
						className: svgElementClassName,
				  }
				: {
						className: 'fill-none',
				  })}
			viewBox='0 0 24 24'
			xmlns='http://www.w3.org/2000/svg'>
			<path
				d='M22 7L2 7'
				{...{
					className: svgElementClassName,
				}}
				strokeLinejoin='round'
				strokeLinecap='round'
				strokeWidth='1.5'
			/>
			<path
				d='M19 12L5 12'
				{...{
					className: svgElementClassName,
				}}
				strokeLinejoin='round'
				strokeLinecap='round'
				strokeWidth='1.5'
			/>
			<path
				d='M16 17H8'
				{...{
					className: svgElementClassName,
				}}
				strokeLinejoin='round'
				strokeLinecap='round'
				strokeWidth='1.5'
			/>
		</svg>
	</div>
);

export const ApplicantsIcon = ({
	svgElementClassName,
	applyToSvgEl,
	className,
	styles,
}: TComponentBasicProps) => (
	<div
		{...{
			style: styles,
			className,
		}}>
		<svg
			viewBox='0 0 25 24'
			{...(applyToSvgEl
				? {
						className: svgElementClassName,
				  }
				: {
						className: 'fill-none',
				  })}
			xmlns='http://www.w3.org/2000/svg'>
			<path
				d='M18.095 10.9314C19.6973 10.9314 20.9971 9.63249 20.9971 8.03016C20.9971 6.42782 19.6973 5.12891 18.095 5.12891'
				{...{
					className: svgElementClassName,
				}}
				strokeWidth='1.5'
				strokeLinecap='round'
				strokeLinejoin='round'
			/>
			<path
				d='M19.4292 14.085C19.9077 14.118 20.3834 14.1858 20.8519 14.2912C21.5027 14.4186 22.2855 14.6854 22.5642 15.2693C22.742 15.6433 22.742 16.0787 22.5642 16.4536C22.2864 17.0375 21.5027 17.3034 20.8519 17.4372'
				{...{
					className: svgElementClassName,
				}}
				strokeWidth='1.5'
				strokeLinecap='round'
				strokeLinejoin='round'
			/>
			<path
				d='M6.79011 10.9314C5.18777 10.9314 3.88794 9.63249 3.88794 8.03016C3.88794 6.42782 5.18777 5.12891 6.79011 5.12891'
				{...{
					className: svgElementClassName,
				}}
				strokeWidth='1.5'
				strokeLinecap='round'
				strokeLinejoin='round'
			/>
			<path
				d='M5.45589 14.085C4.97739 14.118 4.50164 14.1858 4.03322 14.2912C3.38239 14.4186 2.59956 14.6854 2.32181 15.2693C2.14306 15.6433 2.14306 16.0787 2.32181 16.4536C2.59864 17.0375 3.38239 17.3034 4.03322 17.4372'
				{...{
					className: svgElementClassName,
				}}
				strokeWidth='1.5'
				strokeLinecap='round'
				strokeLinejoin='round'
			/>
			<path
				fillRule='evenodd'
				clipRule='evenodd'
				d='M12.4379 14.71C15.6847 14.71 18.4586 15.2013 18.4586 17.1675C18.4586 19.1329 15.7031 19.6425 12.4379 19.6425C9.19015 19.6425 6.41724 19.1512 6.41724 17.185C6.41724 15.2187 9.17274 14.71 12.4379 14.71Z'
				{...{
					className: svgElementClassName,
				}}
				strokeWidth='1.5'
				strokeLinecap='round'
				strokeLinejoin='round'
			/>
			<path
				fillRule='evenodd'
				clipRule='evenodd'
				d='M12.4378 11.9049C10.2965 11.9049 8.57959 10.188 8.57959 8.04575C8.57959 5.90442 10.2965 4.1875 12.4378 4.1875C14.5792 4.1875 16.2961 5.90442 16.2961 8.04575C16.2961 10.188 14.5792 11.9049 12.4378 11.9049Z'
				{...{
					className: svgElementClassName,
				}}
				strokeWidth='1.5'
				strokeLinecap='round'
				strokeLinejoin='round'
			/>
		</svg>
	</div>
);

export const SupportIcon = ({
	svgElementClassName,
	applyToSvgEl,
	className,
	styles,
}: TComponentBasicProps) => (
	<div
		{...{
			style: styles,
			className,
		}}>
		<svg
			{...(applyToSvgEl
				? {
						className: svgElementClassName,
				  }
				: {
						className: 'fill-none',
				  })}
			viewBox='0 0 24 24'
			xmlns='http://www.w3.org/2000/svg'>
			<path
				d='M4.93 4.93L9.17 9.17M14.83 14.83L19.07 19.07M19.07 4.93L14.83 9.17L18.36 5.64M4.93 19.07L9.17 14.83M22 12C22 17.5228 17.5228 22 12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12ZM16 12C16 14.2091 14.2091 16 12 16C9.79086 16 8 14.2091 8 12C8 9.79086 9.79086 8 12 8C14.2091 8 16 9.79086 16 12Z'
				{...{
					className: svgElementClassName,
				}}
				strokeWidth='1.5'
				strokeLinecap='round'
				strokeLinejoin='round'
			/>
		</svg>
	</div>
);

export const ArrowUpIcon = ({
	svgElementClassName,
	applyToSvgEl = false,
	className,
	styles,
}: TComponentBasicProps) => (
	<div
		{...{
			style: styles,
			className,
		}}>
		<svg viewBox='0 0 20 20' fill='none' xmlns='http://www.w3.org/2000/svg'>
			<path
				d='M9.99984 15.8332V4.1665M9.99984 4.1665L4.1665 9.99984M9.99984 4.1665L15.8332 9.99984'
				{...{
					className: svgElementClassName,
				}}
				strokeWidth='1.5'
				strokeLinecap='round'
				strokeLinejoin='round'
			/>
		</svg>
	</div>
);

export const WorkIcon = ({
	svgElementClassName,
	applyToSvgEl = false,
	className,
	styles,
}: TComponentBasicProps) => (
	<div
		{...{
			style: styles,
			className,
		}}>
		<svg
			viewBox='0 0 61 60'
			{...(applyToSvgEl
				? {
						className: svgElementClassName,
				  }
				: {
						className: 'fill-none',
				  })}
			xmlns='http://www.w3.org/2000/svg'>
			<path
				d='M27.4279 8.79745C25.752 8.79745 24.3263 9.962 23.9261 11.5316H37.3829C36.9827 9.962 35.5569 8.79745 33.8811 8.79745H27.4279ZM41.1848 11.5316H46.1372C51.3899 11.5316 55.667 15.8607 55.667 21.1771C55.667 21.1771 55.5169 23.4278 55.4669 26.5619C55.4619 26.81 55.3418 27.0531 55.1442 27.1999C53.9411 28.0885 52.8406 28.8227 52.7405 28.8733C48.5885 31.6581 43.7635 33.6176 38.6235 34.5923C38.2883 34.6581 37.9581 34.4834 37.7881 34.1847C36.3473 31.6885 33.656 30.0632 30.6545 30.0632C27.673 30.0632 24.9566 31.6708 23.4734 34.1695C23.3008 34.4631 22.9756 34.6328 22.643 34.5695C17.5454 33.5923 12.7205 31.6353 8.59346 28.8986L6.19225 27.2277C5.99215 27.1012 5.86709 26.8733 5.86709 26.6201C5.79205 25.329 5.66699 21.1771 5.66699 21.1771C5.66699 15.8607 9.94413 11.5316 15.1968 11.5316H20.1242C20.5995 7.86074 23.676 5 27.4279 5H33.8811C37.633 5 40.7095 7.86074 41.1848 11.5316ZM54.8166 32.0381L54.7165 32.0887C49.664 35.4811 43.586 37.7343 37.2078 38.671C36.3073 38.7976 35.4069 38.2153 35.1567 37.3039C34.6065 35.2279 32.8306 33.8609 30.7045 33.8609H30.6795H30.6295C28.5034 33.8609 26.7275 35.2279 26.1772 37.3039C25.9271 38.2153 25.0267 38.7976 24.1262 38.671C17.748 37.7343 11.67 35.4811 6.61747 32.0887C6.59245 32.0634 6.34233 31.9115 6.14223 32.0381C5.91712 32.1647 5.91712 32.4685 5.91712 32.4685L6.0922 45.3798C6.0922 50.6962 10.3443 55 15.597 55H45.712C50.9646 55 55.2168 50.6962 55.2168 45.3798L55.4169 32.4685C55.4169 32.4685 55.4169 32.1647 55.1918 32.0381C55.0667 31.9621 54.9166 31.9875 54.8166 32.0381ZM32.5304 42.6456C32.5304 43.7089 31.705 44.5444 30.6545 44.5444C29.629 44.5444 28.7785 43.7089 28.7785 42.6456V39.3798C28.7785 38.3419 29.629 37.4811 30.6545 37.4811C31.705 37.4811 32.5304 38.3419 32.5304 39.3798V42.6456Z'
				{...{
					className: svgElementClassName,
				}}
				fillRule='evenodd'
				clipRule='evenodd'
				strokeWidth='1.5'
				strokeLinecap='round'
				strokeLinejoin='round'
			/>
		</svg>
	</div>
);

export const TickIcon = ({
	svgElementClassName,
	className,
	styles,
}: TComponentBasicProps) => (
	<div
		{...{
			style: styles,
			className,
		}}>
		<svg viewBox='0 0 60 60' fill='none' xmlns='http://www.w3.org/2000/svg'>
			<path
				d='M19.1755 4.99951H40.8505C49.3255 4.99951 55.0005 10.9495 55.0005 19.7995V40.227C55.0005 49.0495 49.3255 54.9995 40.8505 54.9995H19.1755C10.7005 54.9995 5.00049 49.0495 5.00049 40.227V19.7995C5.00049 10.9495 10.7005 4.99951 19.1755 4.99951ZM28.5755 37.4745L40.4505 25.5995C41.3005 24.7495 41.3005 23.3745 40.4505 22.4995C39.6005 21.6495 38.2005 21.6495 37.3505 22.4995L27.0255 32.8245L22.6505 28.4495C21.8005 27.5995 20.4005 27.5995 19.5505 28.4495C18.7005 29.2995 18.7005 30.6745 19.5505 31.5495L25.5005 37.4745C25.9255 37.8995 26.4755 38.0995 27.0255 38.0995C27.6005 38.0995 28.1505 37.8995 28.5755 37.4745Z'
				{...{
					className: svgElementClassName,
				}}
				strokeLinecap='round'
				strokeLinejoin='round'
				clipRule='evenodd'
				fillRule='evenodd'
				strokeWidth='1.5'
			/>
		</svg>
	</div>
);

export const YSportIcon = ({
	svgElementClassName,
	className,
	styles,
}: TComponentBasicProps) => (
	<div
		{...{
			style: styles,
			className,
		}}>
		<svg viewBox='0 0 55 54' fill='none' xmlns='http://www.w3.org/2000/svg'>
			<g clipPath='url(#clip0_1042_7722)'>
				<path
					d='M20.3408 7.77511C20.2047 7.69093 20.0954 7.56978 20.0255 7.42579C19.9557 7.28181 19.9282 7.12094 19.9464 6.96194C19.9645 6.80295 20.0275 6.65239 20.1279 6.52783C20.2284 6.40327 20.3622 6.30985 20.5138 6.25847C23.5914 5.19807 26.8664 4.83625 30.1013 5.19928C33.3361 5.56232 36.4495 6.64109 39.2155 8.3573C39.3157 8.4205 39.4015 8.5041 39.4673 8.60265C39.5331 8.70121 39.5774 8.81252 39.5973 8.92933C39.6172 9.04614 39.6122 9.16583 39.5828 9.28061C39.5534 9.39539 39.5001 9.50268 39.4264 9.5955C36.9841 12.7165 33.989 15.362 30.5903 17.4002C27.8448 13.5448 24.3609 10.2731 20.3408 7.77511ZM27.5781 18.9843C24.4973 14.7806 20.4443 11.3854 15.7656 9.08925C15.6316 9.02419 15.4826 8.99632 15.3342 9.00857C15.1857 9.02081 15.0433 9.07272 14.9218 9.15886C11.1342 11.8681 8.30282 15.7083 6.83447 20.1276C6.79759 20.2406 6.78499 20.3601 6.79751 20.4783C6.81003 20.5965 6.84739 20.7108 6.90714 20.8135C6.96689 20.9163 7.04767 21.0053 7.1442 21.0746C7.24073 21.144 7.35083 21.1922 7.46729 21.216C9.66896 21.6906 11.9144 21.9324 14.1667 21.9375C18.7987 21.94 23.3755 20.9322 27.5781 18.9843ZM49.4734 24.6143C48.937 19.7216 46.7679 15.1524 43.3161 11.6437C43.232 11.5582 43.1305 11.4916 43.0186 11.4484C42.9067 11.4053 42.7868 11.3864 42.6671 11.3932C42.5473 11.4 42.4303 11.4322 42.324 11.4878C42.2177 11.5434 42.1245 11.621 42.0505 11.7154C39.3808 15.1165 36.1151 18.0041 32.4128 20.2373C33.5694 22.2411 34.5267 24.3536 35.271 26.5443C38.293 25.7251 41.4105 25.3108 44.5417 25.3125C45.8808 25.3125 47.2188 25.3879 48.5495 25.5382C48.6733 25.5505 48.7983 25.5353 48.9156 25.4937C49.0329 25.452 49.1395 25.3849 49.2278 25.2972C49.3161 25.2095 49.3839 25.1034 49.4264 24.9864C49.4688 24.8694 49.4849 24.7445 49.4734 24.6206V24.6143ZM36.2033 29.7822C36.8285 32.4418 37.1435 35.1649 37.142 37.897C37.1407 40.5121 36.8499 43.1189 36.275 45.67C36.2383 45.8263 36.2468 45.9898 36.2997 46.1413C36.3526 46.2929 36.4477 46.4262 36.5737 46.5256C36.6997 46.6251 36.8514 46.6865 37.0111 46.7027C37.1708 46.7189 37.3318 46.6892 37.4753 46.6171C40.6745 45.0122 43.4337 42.6507 45.5132 39.7375C47.5927 36.8243 48.9296 33.4475 49.408 29.9003C49.4224 29.7897 49.4148 29.6773 49.3856 29.5697C49.3563 29.462 49.306 29.3613 49.2375 29.2732C49.1691 29.1851 49.0838 29.1115 48.9867 29.0566C48.8896 29.0016 48.7826 28.9665 48.6718 28.9532C44.5005 28.4164 40.2643 28.703 36.2033 29.797V29.7822ZM32.0605 27.5779C31.3804 25.5834 30.5049 23.6608 29.447 21.8383C24.679 24.1289 19.4563 25.3164 14.1667 25.3125C11.694 25.3126 9.22818 25.0545 6.80916 24.5425C6.69245 24.5179 6.57184 24.5183 6.4553 24.5437C6.33875 24.5691 6.22892 24.6189 6.13304 24.6899C6.03716 24.7609 5.95742 24.8514 5.89907 24.9554C5.84073 25.0594 5.8051 25.1747 5.79455 25.2935C5.75096 25.856 5.72846 26.4248 5.72705 27C5.72594 30.0038 6.34342 32.9757 7.54101 35.7306C8.7386 38.4854 10.4906 40.9641 12.688 43.0122C12.7807 43.0972 12.8912 43.1603 13.0114 43.1971C13.1316 43.2338 13.2586 43.2433 13.3829 43.2247C13.5073 43.2061 13.6259 43.1599 13.7301 43.0896C13.8343 43.0192 13.9215 42.9265 13.9853 42.8182C18.1024 35.8322 24.4782 30.4587 32.0605 27.5843V27.5779ZM16.6325 44.9824C16.5771 45.0792 16.5414 45.186 16.5275 45.2967C16.5136 45.4074 16.5218 45.5197 16.5516 45.6273C16.5814 45.7347 16.6323 45.8353 16.7012 45.923C16.7701 46.0107 16.8558 46.0839 16.9531 46.1383C21.3645 48.6116 26.4957 49.4828 31.4762 48.6042C31.6244 48.5783 31.7627 48.5126 31.8764 48.4142C31.9901 48.3157 32.0749 48.1882 32.1217 48.0452C33.2096 44.7745 33.7651 41.3502 33.767 37.9033C33.7674 35.5286 33.5028 33.1613 32.9781 30.8453C26.0663 33.5383 20.2937 38.531 16.6325 44.9824Z'
					{...{
						className: svgElementClassName,
					}}
					strokeLinecap='round'
					strokeLinejoin='round'
					clipRule='evenodd'
					fillRule='evenodd'
					strokeWidth='1.5'
				/>
			</g>
			<defs>
				<clipPath id='clip0_1042_7722'>
					<rect
						width='54'
						height='54'
						{...{
							className: svgElementClassName,
						}}
						strokeLinecap='round'
						strokeLinejoin='round'
						clipRule='evenodd'
						fillRule='evenodd'
						strokeWidth='1.5'
						transform='translate(0.666626)'
					/>
				</clipPath>
			</defs>
		</svg>
	</div>
);

export const HealthCareIcon = ({
	svgElementClassName,
	className,
	styles,
}: TComponentBasicProps) => (
	<div
		{...{
			style: styles,
			className,
		}}>
		<svg viewBox='0 0 54 54' fill='none' xmlns='http://www.w3.org/2000/svg'>
			<g clipPath='url(#clip0_1042_7936)'>
				<path
					d='M50.6249 19.8281C50.6249 34.5938 28.7317 46.5455 27.7993 47.0391C27.5536 47.1713 27.2789 47.2405 26.9999 47.2405C26.7208 47.2405 26.4462 47.1713 26.2004 47.0391C25.4938 46.6594 12.7953 39.7216 6.65074 29.9763C6.57148 29.8487 6.52774 29.7022 6.52405 29.552C6.52036 29.4018 6.55685 29.2533 6.62975 29.1219C6.70265 28.9905 6.80931 28.881 6.93871 28.8046C7.06811 28.7282 7.21556 28.6878 7.36582 28.6875H15.1874C15.4653 28.6877 15.7389 28.6192 15.984 28.4882C16.2291 28.3572 16.438 28.1677 16.5922 27.9366L18.5624 24.9834L23.9075 32.9991C24.1123 33.3062 24.4122 33.5378 24.7612 33.6582C25.1102 33.7786 25.4891 33.7812 25.8397 33.6656C26.2114 33.5401 26.5291 33.2916 26.7404 32.9611L29.5902 28.6875H33.7499C33.9812 28.688 34.2102 28.6409 34.4226 28.5492C34.6349 28.4575 34.8262 28.3231 34.9845 28.1544C35.1427 27.9857 35.2646 27.7862 35.3425 27.5684C35.4204 27.3505 35.4527 27.119 35.4374 26.8882C35.3996 26.4545 35.1993 26.051 34.8765 25.7588C34.5538 25.4666 34.1325 25.3071 33.6971 25.3125H28.6874C28.4095 25.3123 28.1358 25.3808 27.8908 25.5118C27.6457 25.6428 27.4368 25.8323 27.2825 26.0634L25.3124 29.0166L19.9672 21.0009C19.7624 20.6938 19.4625 20.4622 19.1135 20.3418C18.7645 20.2215 18.3857 20.2188 18.035 20.3344C17.6634 20.4599 17.3456 20.7084 17.1343 21.0389L14.2846 25.3125H4.96324C4.78291 25.313 4.60717 25.2557 4.46178 25.149C4.31639 25.0424 4.20899 24.8919 4.15535 24.7198C3.64639 23.1388 3.38317 21.489 3.37488 19.8281C3.37879 16.3608 4.75791 13.0366 7.20969 10.5848C9.66147 8.13303 12.9857 6.75391 16.453 6.75C20.8089 6.75 24.6226 8.62312 26.9999 11.7893C29.3771 8.62312 33.1909 6.75 37.5468 6.75C41.0141 6.75391 44.3383 8.13303 46.7901 10.5848C49.2418 13.0366 50.621 16.3608 50.6249 19.8281Z'
					{...{
						className: svgElementClassName,
					}}
					strokeLinecap='round'
					strokeLinejoin='round'
					clipRule='evenodd'
					fillRule='evenodd'
					strokeWidth='1.5'
					transform='translate(0.666626)'
				/>
			</g>
			<defs>
				<clipPath id='clip0_1042_7936'>
					<rect
						width='54'
						height='54'
						{...{
							className: svgElementClassName,
						}}
						strokeLinecap='round'
						strokeLinejoin='round'
						clipRule='evenodd'
						fillRule='evenodd'
						strokeWidth='1.5'
						transform='translate(0.666626)'
					/>
				</clipPath>
			</defs>
		</svg>
	</div>
);

export const AgricultureAndLivestockIcon = ({
	svgElementClassName,
	className,
	styles,
}: TComponentBasicProps) => (
	<div
		{...{
			style: styles,
			className,
		}}>
		<svg viewBox='0 0 55 54' fill='none' xmlns='http://www.w3.org/2000/svg'>
			<g clipPath='url(#clip0_1042_7739)'>
				<path
					d='M43.6619 31.8662C41.6389 33.096 39.3153 33.7428 36.9478 33.7351C34.9644 33.7194 33.0034 33.3137 31.1765 32.5412C29.7686 34.5289 29.015 36.906 29.0208 39.3418V45.5624C29.0213 45.7937 28.9742 46.0227 28.8825 46.2351C28.7908 46.4475 28.6564 46.6387 28.4877 46.797C28.3189 46.9552 28.1195 47.0771 27.9016 47.155C27.6838 47.2329 27.4523 47.2652 27.2215 47.2499C26.7877 47.2121 26.3843 47.0118 26.0921 46.689C25.7998 46.3663 25.6404 45.945 25.6458 45.5097V42.8856L17.4994 34.7392C16.2884 35.191 15.0076 35.4273 13.7151 35.4374C11.9358 35.4418 10.1898 34.9549 8.66952 34.0304C4.07319 31.2376 1.59889 24.8104 2.07772 16.8306C2.10183 16.4178 2.27669 16.0281 2.56911 15.7357C2.86153 15.4433 3.25114 15.2684 3.66397 15.2443C11.6437 14.7739 18.071 17.2398 20.8554 21.8361C21.9493 23.6377 22.4269 25.7465 22.2159 27.8436C22.2028 28.0061 22.1429 28.1613 22.0435 28.2905C21.944 28.4196 21.8093 28.5172 21.6555 28.5715C21.5018 28.6257 21.3357 28.6342 21.1772 28.596C21.0187 28.5578 20.8747 28.4745 20.7626 28.3562L16.7126 24.1164C16.3935 23.8133 15.9687 23.6468 15.5287 23.6524C15.0886 23.658 14.6682 23.8354 14.357 24.1465C14.0458 24.4577 13.8685 24.8781 13.8629 25.3182C13.8573 25.7582 14.0238 26.183 14.3269 26.5021L25.6922 38.1564C25.7048 37.9918 25.7196 37.8273 25.7365 37.6649C26.1055 34.5361 27.4861 31.6135 29.6683 29.3413L40.3397 18.0646C40.6563 17.7482 40.8343 17.319 40.8345 16.8714C40.8347 16.4238 40.6571 15.9945 40.3407 15.6778C40.0244 15.3612 39.5952 15.1832 39.1476 15.183C38.7 15.1828 38.2706 15.3604 37.954 15.6768L27.618 26.6075C27.5146 26.7171 27.3837 26.797 27.2389 26.8389C27.0941 26.8807 26.9407 26.883 26.7948 26.8456C26.6488 26.8081 26.5155 26.7322 26.4088 26.6258C26.3021 26.5194 26.2258 26.3864 26.1879 26.2405C25.188 22.5533 25.6289 18.883 27.5379 15.7316C31.3052 9.51317 40.0718 6.18457 50.9899 6.82582C51.4027 6.84993 51.7924 7.02479 52.0848 7.31721C52.3772 7.60963 52.552 7.99924 52.5762 8.41207C53.209 19.3323 49.8804 28.0989 43.6619 31.8662Z'
					{...{
						className: svgElementClassName,
					}}
					strokeLinecap='round'
					strokeLinejoin='round'
					clipRule='evenodd'
					fillRule='evenodd'
					strokeWidth='1.5'
				/>
			</g>
			<defs>
				<clipPath id='clip0_1042_7739'>
					<rect
						width='54'
						height='54'
						{...{
							className: svgElementClassName,
						}}
						strokeLinecap='round'
						strokeLinejoin='round'
						clipRule='evenodd'
						fillRule='evenodd'
						strokeWidth='1.5'
						transform='translate(0.333252)'
					/>
				</clipPath>
			</defs>
		</svg>
	</div>
);

export const WaterIcon = ({
	svgElementClassName,
	className,
	styles,
}: TComponentBasicProps) => (
	<div
		{...{
			style: styles,
			className,
		}}>
		<svg viewBox='0 0 55 54' fill='none' xmlns='http://www.w3.org/2000/svg'>
			<g clipPath='url(#clip0_1042_7776)'>
				<path
					d='M37.3698 10.0723C34.7642 7.06312 31.8317 4.35346 28.6264 1.99337C28.3427 1.79461 28.0046 1.68799 27.6582 1.68799C27.3118 1.68799 26.9737 1.79461 26.69 1.99337C23.4906 4.35444 20.5638 7.06407 17.9635 10.0723C12.1648 16.7316 9.10413 23.7516 9.10413 30.375C9.10413 35.2981 11.0598 40.0195 14.541 43.5007C18.0221 46.9818 22.7435 48.9375 27.6666 48.9375C32.5897 48.9375 37.3112 46.9818 40.7923 43.5007C44.2734 40.0195 46.2291 35.2981 46.2291 30.375C46.2291 23.7516 43.1684 16.7316 37.3698 10.0723ZM39.4475 32.3452C39.0099 34.7893 37.834 37.0407 36.0781 38.7963C34.3221 40.5518 32.0705 41.7273 29.6262 42.1643C29.5362 42.1788 29.4453 42.1865 29.3541 42.1875C28.9308 42.1874 28.523 42.0282 28.2116 41.7415C27.9002 41.4548 27.7079 41.0616 27.6729 40.6397C27.6378 40.2179 27.7626 39.7983 28.0224 39.4641C28.2823 39.13 28.6582 38.9057 29.0757 38.8357C32.5709 38.2472 35.5367 35.2814 36.1294 31.7799C36.2044 31.3385 36.4516 30.9449 36.8168 30.6858C37.1819 30.4267 37.635 30.3233 38.0764 30.3982C38.5178 30.4732 38.9113 30.7204 39.1704 31.0855C39.4295 31.4507 39.533 31.9038 39.458 32.3452H39.4475Z'
					{...{
						className: svgElementClassName,
					}}
					strokeLinecap='round'
					strokeLinejoin='round'
					clipRule='evenodd'
					fillRule='evenodd'
					strokeWidth='1.5'
				/>
			</g>
			<defs>
				<clipPath id='clip0_1042_7776'>
					<rect
						width='54'
						height='54'
						{...{
							className: svgElementClassName,
						}}
						strokeLinecap='round'
						strokeLinejoin='round'
						clipRule='evenodd'
						fillRule='evenodd'
						strokeWidth='1.5'
						transform='translate(0.666626)'
					/>
				</clipPath>
			</defs>
		</svg>
	</div>
);

export const RoadsIcon = ({
	svgElementClassName,
	className,
	styles,
}: TComponentBasicProps) => (
	<div
		{...{
			style: styles,
			className,
		}}>
		<svg viewBox='0 0 55 54' fill='none' xmlns='http://www.w3.org/2000/svg'>
			<g clipPath='url(#clip0_1042_5742)'>
				<path
					d='M50.7473 39.6733L36.9688 15.1877H49.2032C49.6412 15.1974 50.0665 15.0398 50.3925 14.7471C50.7185 14.4544 50.9208 14.0485 50.9582 13.612C50.9735 13.3812 50.9412 13.1497 50.8633 12.9319C50.7854 12.714 50.6636 12.5146 50.5053 12.3458C50.347 12.1771 50.1558 12.0427 49.9434 11.951C49.731 11.8593 49.5021 11.8122 49.2707 11.8127H5.45268C5.01646 11.8058 4.59384 11.9645 4.27009 12.257C3.94634 12.5494 3.74555 12.9537 3.70822 13.3884C3.6929 13.6192 3.72519 13.8508 3.80311 14.0686C3.88102 14.2864 4.00289 14.4859 4.16115 14.6546C4.3194 14.8234 4.51066 14.9577 4.72304 15.0495C4.93542 15.1412 5.16439 15.1882 5.39572 15.1877H17.6976L3.91916 39.6733C3.74229 39.9877 3.67082 40.3505 3.71524 40.7085C3.75965 41.0665 3.91762 41.4008 4.16596 41.6625C4.33032 41.8312 4.52726 41.9648 4.74483 42.0551C4.96239 42.1454 5.19604 42.1905 5.43158 42.1877H24.802C25.0257 42.1877 25.2404 42.0988 25.3986 41.9406C25.5568 41.7824 25.6457 41.5677 25.6457 41.344V37.1822C25.6399 36.7467 25.7991 36.3251 26.0914 36.0023C26.3838 35.6794 26.7875 35.4792 27.2214 35.4419C27.4523 35.4266 27.6838 35.4589 27.9016 35.5368C28.1194 35.6147 28.3189 35.7366 28.4876 35.8949C28.6564 36.0531 28.7908 36.2444 28.8825 36.4568C28.9742 36.6691 29.0212 36.8981 29.0207 37.1294V41.3482C29.0207 41.572 29.1096 41.7866 29.2679 41.9448C29.4261 42.103 29.6407 42.1919 29.8645 42.1919H49.2222C49.4577 42.1947 49.6914 42.1496 49.909 42.0593C50.1265 41.969 50.3235 41.8354 50.4878 41.6667C50.7391 41.4062 50.9 41.0718 50.9468 40.7129C50.9935 40.3539 50.9235 39.9895 50.7473 39.6733ZM29.0207 29.5315C29.0207 29.979 28.8429 30.4082 28.5265 30.7247C28.21 31.0412 27.7808 31.219 27.3332 31.219C26.8857 31.219 26.4564 31.0412 26.14 30.7247C25.8235 30.4082 25.6457 29.979 25.6457 29.5315V26.1565C25.6457 25.7089 25.8235 25.2797 26.14 24.9632C26.4564 24.6468 26.8857 24.469 27.3332 24.469C27.7808 24.469 28.21 24.6468 28.5265 24.9632C28.8429 25.2797 29.0207 25.7089 29.0207 26.1565V29.5315ZM29.0207 18.5627C29.0207 19.0103 28.8429 19.4395 28.5265 19.756C28.21 20.0724 27.7808 20.2502 27.3332 20.2502C26.8857 20.2502 26.4564 20.0724 26.14 19.756C25.8235 19.4395 25.6457 19.0103 25.6457 18.5627V16.8752C25.6457 16.4277 25.8235 15.9984 26.14 15.682C26.4564 15.3655 26.8857 15.1877 27.3332 15.1877C27.7808 15.1877 28.21 15.3655 28.5265 15.682C28.8429 15.9984 29.0207 16.4277 29.0207 16.8752V18.5627Z'
					{...{
						className: svgElementClassName,
					}}
					strokeLinecap='round'
					strokeLinejoin='round'
					clipRule='evenodd'
					fillRule='evenodd'
					strokeWidth='1.5'
				/>
			</g>
			<defs>
				<clipPath id='clip0_1042_5742'>
					<rect
						width='54'
						height='54'
						{...{
							className: svgElementClassName,
						}}
						strokeLinecap='round'
						strokeLinejoin='round'
						clipRule='evenodd'
						fillRule='evenodd'
						strokeWidth='1.5'
						transform='translate(0.333252)'
					/>
				</clipPath>
			</defs>
		</svg>
	</div>
);

export const EnergyIcon = ({
	svgElementClassName,
	className,
	styles,
}: TComponentBasicProps) => (
	<div
		{...{
			style: styles,
			className,
		}}>
		<svg viewBox='0 0 54 54' fill='none' xmlns='http://www.w3.org/2000/svg'>
			<g clipPath='url(#clip0_1046_5709)'>
				<path
					d='M37.125 48.9375C37.125 49.3851 36.9472 49.8143 36.6308 50.1308C36.3143 50.4472 35.8851 50.625 35.4375 50.625H18.5625C18.115 50.625 17.6858 50.4472 17.3693 50.1308C17.0528 49.8143 16.875 49.3851 16.875 48.9375C16.875 48.49 17.0528 48.0607 17.3693 47.7443C17.6858 47.4278 18.115 47.25 18.5625 47.25H35.4375C35.8851 47.25 36.3143 47.4278 36.6308 47.7443C36.9472 48.0607 37.125 48.49 37.125 48.9375ZM45.5625 21.9375C45.5698 24.7507 44.9343 27.5283 43.7045 30.0584C42.4747 32.5885 40.6832 34.8043 38.4666 36.5365C38.0521 36.8542 37.7158 37.2624 37.4833 37.73C37.2508 38.1976 37.1282 38.7122 37.125 39.2344V40.5C37.125 41.3951 36.7695 42.2536 36.1365 42.8865C35.5036 43.5194 34.6451 43.875 33.75 43.875H20.25C19.3549 43.875 18.4965 43.5194 17.8635 42.8865C17.2306 42.2536 16.875 41.3951 16.875 40.5V39.2344C16.8747 38.7184 16.756 38.2094 16.5282 37.7465C16.3004 37.2835 15.9695 36.879 15.5609 36.5639C13.3498 34.8419 11.5595 32.6395 10.3254 30.1234C9.09125 27.6073 8.44568 24.8434 8.43753 22.0409C8.38269 11.9876 16.508 3.61549 26.5528 3.37502C29.0279 3.31537 31.4898 3.75144 33.7938 4.65755C36.0978 5.56367 38.1972 6.92151 39.9686 8.65118C41.7399 10.3808 43.1473 12.4474 44.108 14.7291C45.0687 17.0109 45.5632 19.4618 45.5625 21.9375ZM38.7893 19.9674C38.3518 17.5232 37.1758 15.2718 35.4199 13.5163C33.664 11.7607 31.4123 10.5853 28.9681 10.1482C28.7495 10.1114 28.5258 10.1179 28.3098 10.1675C28.0938 10.2171 27.8897 10.3088 27.7091 10.4373C27.5285 10.5658 27.375 10.7286 27.2573 10.9164C27.1396 11.1042 27.0601 11.3134 27.0232 11.532C26.9864 11.7505 26.993 11.9742 27.0426 12.1902C27.0922 12.4062 27.1838 12.6104 27.3123 12.791C27.4408 12.9716 27.6036 13.1251 27.7914 13.2428C27.9793 13.3604 28.1884 13.44 28.407 13.4768C31.9022 14.0653 34.868 17.0311 35.4607 20.5327C35.5275 20.9257 35.7313 21.2824 36.0359 21.5395C36.3405 21.7967 36.7264 21.9377 37.125 21.9375C37.2204 21.9369 37.3156 21.9292 37.4098 21.9143C37.8509 21.839 38.244 21.5916 38.5027 21.2265C38.7614 20.8614 38.8645 20.4085 38.7893 19.9674Z'
					{...{
						className: svgElementClassName,
					}}
					strokeLinecap='round'
					strokeLinejoin='round'
					clipRule='evenodd'
					fillRule='evenodd'
					strokeWidth='1.5'
				/>
			</g>
			<defs>
				<clipPath id='clip0_1046_5709'>
					<rect
						width='54'
						height='54'
						{...{
							className: svgElementClassName,
						}}
						strokeLinecap='round'
						strokeLinejoin='round'
						clipRule='evenodd'
						fillRule='evenodd'
						strokeWidth='1.5'
					/>
				</clipPath>
			</defs>
		</svg>
	</div>
);

export const TradeIcon = ({
	svgElementClassName,
	className,
	styles,
}: TComponentBasicProps) => (
	<div
		{...{
			style: styles,
			className,
		}}>
		<svg
			width='55'
			height='54'
			viewBox='0 0 55 54'
			fill='none'
			xmlns='http://www.w3.org/2000/svg'>
			<g clipPath='url(#clip0_1042_6613)'>
				<path
					d='M51.2916 43.875H47.9166V28.6875C47.9166 28.677 47.9166 28.6685 47.9166 28.658C47.9166 28.6474 47.9166 28.5968 47.9166 28.5673C47.9166 28.5377 47.9166 28.5082 47.9166 28.4808C47.9177 28.4703 47.9177 28.4597 47.9166 28.4491L44.7526 6.27329C44.6339 5.46678 44.2288 4.72996 43.6114 4.19773C42.9939 3.66549 42.2054 3.37343 41.3902 3.37501H37.568C36.7565 3.37848 35.9731 3.67283 35.36 4.20461C34.7469 4.73639 34.3449 5.47036 34.2268 6.27329L31.7883 23.3402L23.6166 17.2125C23.3659 17.0245 23.0678 16.91 22.7557 16.8818C22.4436 16.8537 22.1298 16.913 21.8495 17.0532C21.5692 17.1933 21.3334 17.4088 21.1687 17.6753C21.0039 17.9419 20.9166 18.2491 20.9166 18.5625V25.3125L10.1166 17.2125C9.86591 17.0245 9.5678 16.91 9.25567 16.8818C8.94355 16.8537 8.62976 16.913 8.34945 17.0532C8.06915 17.1933 7.83341 17.4088 7.66865 17.6753C7.50389 17.9419 7.41663 18.2491 7.41663 18.5625V43.875H4.04163C3.59407 43.875 3.16485 44.0528 2.84838 44.3693C2.53192 44.6857 2.35413 45.115 2.35413 45.5625C2.35413 46.0101 2.53192 46.4393 2.84838 46.7557C3.16485 47.0722 3.59407 47.25 4.04163 47.25H51.2916C51.7392 47.25 52.1684 47.0722 52.4849 46.7557C52.8013 46.4393 52.9791 46.0101 52.9791 45.5625C52.9791 45.115 52.8013 44.6857 52.4849 44.3693C52.1684 44.0528 51.7392 43.875 51.2916 43.875ZM23.4479 38.8125H17.5416C17.0941 38.8125 16.6649 38.6347 16.3484 38.3182C16.0319 38.0018 15.8541 37.5726 15.8541 37.125C15.8541 36.6775 16.0319 36.2482 16.3484 35.9318C16.6649 35.6153 17.0941 35.4375 17.5416 35.4375H23.4479C23.8954 35.4375 24.3246 35.6153 24.6411 35.9318C24.9576 36.2482 25.1354 36.6775 25.1354 37.125C25.1354 37.5726 24.9576 38.0018 24.6411 38.3182C24.3246 38.6347 23.8954 38.8125 23.4479 38.8125ZM37.7916 38.8125H31.8854C31.4378 38.8125 31.0086 38.6347 30.6921 38.3182C30.3757 38.0018 30.1979 37.5726 30.1979 37.125C30.1979 36.6775 30.3757 36.2482 30.6921 35.9318C31.0086 35.6153 31.4378 35.4375 31.8854 35.4375H37.7916C38.2392 35.4375 38.6684 35.6153 38.9849 35.9318C39.3013 36.2482 39.4791 36.6775 39.4791 37.125C39.4791 37.5726 39.3013 38.0018 38.9849 38.3182C38.6684 38.6347 38.2392 38.8125 37.7916 38.8125ZM36.6673 27L34.868 25.65L37.568 6.75001H41.3902L44.2843 27H36.6673Z'
					{...{
						className: svgElementClassName,
					}}
					strokeLinecap='round'
					strokeLinejoin='round'
					clipRule='evenodd'
					fillRule='evenodd'
					strokeWidth='1.5'
				/>
			</g>
			<defs>
				<clipPath id='clip0_1042_6613'>
					<rect
						width='54'
						height='54'
						{...{
							className: svgElementClassName,
						}}
						strokeLinecap='round'
						strokeLinejoin='round'
						clipRule='evenodd'
						fillRule='evenodd'
						strokeWidth='1.5'
						transform='translate(0.666626)'
					/>
				</clipPath>
			</defs>
		</svg>
	</div>
);

export const SuccessTickIcon = ({
	svgElementClassName,
	applyToSvgEl = false,
	className,
	styles,
}: TComponentBasicProps) => (
	<div
		{...{
			style: styles,
			className,
		}}>
		<svg
			viewBox='0 0 260 260'
			{...(applyToSvgEl
				? {
						className: svgElementClassName,
				  }
				: {
						className: 'fill-none',
				  })}
			xmlns='http://www.w3.org/2000/svg'>
			<path
				d='M222.857 121.51V130.053C222.846 150.077 216.362 169.561 204.372 185.598C192.383 201.636 175.53 213.369 156.328 219.046C137.126 224.724 116.603 224.042 97.82 217.103C79.037 210.163 63.0003 197.338 52.1017 180.54C41.2032 163.742 36.0266 143.871 37.3441 123.89C38.6616 103.91 46.4026 84.8902 59.4126 69.6685C72.4225 54.4469 90.0044 43.8386 109.536 39.4257C129.068 35.0127 149.502 37.0317 167.793 45.1814M222.857 55.7673L130 148.717L102.143 120.86'
				{...{
					className: svgElementClassName,
				}}
				strokeLinecap='round'
				strokeLinejoin='round'
				clipRule='evenodd'
				fillRule='evenodd'
				strokeWidth='1.5'
			/>
		</svg>
	</div>
);

export const EmailIcon = ({
	svgElementClassName,
	applyToSvgEl = false,
	className,
	styles,
}: TComponentBasicProps) => (
	<div
		{...{
			style: styles,
			className,
		}}>
		<svg
			viewBox='0 0 21 20'
			{...(applyToSvgEl
				? {
						className: svgElementClassName,
				  }
				: {
						className: 'fill-none',
				  })}
			xmlns='http://www.w3.org/2000/svg'>
			<path
				d='M17.1666 3.33301H3.83329C2.91282 3.33301 2.16663 4.0792 2.16663 4.99967V14.9997C2.16663 15.9201 2.91282 16.6663 3.83329 16.6663H17.1666C18.0871 16.6663 18.8333 15.9201 18.8333 14.9997V4.99967C18.8333 4.0792 18.0871 3.33301 17.1666 3.33301Z'
				strokeWidth='2'
				strokeLinecap='round'
				strokeLinejoin='round'
				{...{
					className: svgElementClassName,
				}}
			/>
			<path
				d='M18.8333 5.83301L11.3583 10.583C11.101 10.7442 10.8036 10.8297 10.5 10.8297C10.1964 10.8297 9.8989 10.7442 9.64163 10.583L2.16663 5.83301'
				strokeWidth='2'
				strokeLinecap='round'
				strokeLinejoin='round'
				{...{
					className: svgElementClassName,
				}}
			/>
		</svg>
	</div>
);

export const HelpIcon = ({
	svgElementClassName,
	applyToSvgEl = false,
	className,
	styles,
}: TComponentBasicProps) => (
	<div
		{...{
			style: styles,
			className,
		}}>
		<svg
			viewBox='0 0 16 16'
			{...(applyToSvgEl
				? {
						className: svgElementClassName,
				  }
				: {
						className: 'fill-none',
				  })}
			xmlns='http://www.w3.org/2000/svg'>
			<g clipPath='url(#clip0_748_19144)'>
				<path
					d='M6.05998 5.99967C6.21672 5.55412 6.52608 5.17841 6.93328 4.9391C7.34048 4.69978 7.81924 4.6123 8.28476 4.69215C8.75028 4.772 9.17252 5.01402 9.4767 5.37536C9.78087 5.7367 9.94735 6.19402 9.94665 6.66634C9.94665 7.99967 7.94665 8.66634 7.94665 8.66634M7.99998 11.333H8.00665M14.6666 7.99967C14.6666 11.6816 11.6819 14.6663 7.99998 14.6663C4.31808 14.6663 1.33331 11.6816 1.33331 7.99967C1.33331 4.31778 4.31808 1.33301 7.99998 1.33301C11.6819 1.33301 14.6666 4.31778 14.6666 7.99967Z'
					strokeWidth='2'
					strokeLinecap='round'
					strokeLinejoin='round'
					{...{
						className: svgElementClassName,
					}}
				/>
			</g>
			<defs>
				<clipPath id='clip0_748_19144'>
					<rect width='16' height='16' fill='white' />
				</clipPath>
			</defs>
		</svg>
	</div>
);

export const DeleteIcon = ({
	svgElementClassName,
	applyToSvgEl = false,
	className,
	styles,
}: TComponentBasicProps) => (
	<div
		{...{
			style: styles,
			className,
		}}>
		<svg
			viewBox='0 0 18 18'
			{...(applyToSvgEl
				? {
						className: svgElementClassName,
				  }
				: {
						className: 'fill-none',
				  })}
			xmlns='http://www.w3.org/2000/svg'>
			<path
				d='M14.4933 7.10107C14.4933 7.10107 14.0861 12.1523 13.8498 14.2801C13.7373 15.2963 13.1096 15.8918 12.0813 15.9106C10.1246 15.9458 8.1656 15.9481 6.2096 15.9068C5.22035 15.8866 4.6031 15.2836 4.49285 14.2853C4.2551 12.1388 3.8501 7.10107 3.8501 7.10107'
				{...{
					className: svgElementClassName,
				}}
				strokeLinecap='round'
				strokeLinejoin='round'
				strokeWidth='2'
			/>
			<path
				d='M15.531 4.67969H2.8125'
				{...{
					className: svgElementClassName,
				}}
				strokeLinecap='round'
				strokeLinejoin='round'
				strokeWidth='2'
			/>
			<path
				d='M13.0804 4.67974C12.4917 4.67974 11.9847 4.26349 11.8692 3.68674L11.6869 2.77474C11.5744 2.35399 11.1934 2.06299 10.7592 2.06299H7.58443C7.15018 2.06299 6.76918 2.35399 6.65668 2.77474L6.47443 3.68674C6.35893 4.26349 5.85193 4.67974 5.26318 4.67974'
				{...{
					className: svgElementClassName,
				}}
				strokeLinecap='round'
				strokeLinejoin='round'
				strokeWidth='2'
			/>
		</svg>
	</div>
);

export const ClockIcon = ({
	svgElementClassName,
	applyToSvgEl = false,
	className,
	styles,
}: TComponentBasicProps) => (
	<div
		{...{
			style: styles,
			className,
		}}>
		<svg
			viewBox='0 0 18 18'
			{...(applyToSvgEl
				? {
						className: svgElementClassName,
				  }
				: {
						className: 'fill-none',
				  })}
			xmlns='http://www.w3.org/2000/svg'>
			<g clipPath='url(#clip0_522_24843)'>
				<path
					d='M9 16.5C13.1421 16.5 16.5 13.1421 16.5 9C16.5 4.85786 13.1421 1.5 9 1.5C4.85786 1.5 1.5 4.85786 1.5 9C1.5 13.1421 4.85786 16.5 9 16.5Z'
					{...{
						className: svgElementClassName,
					}}
					strokeLinecap='round'
					strokeLinejoin='round'
					strokeWidth='2'
				/>
				<path d='M9 4.5V9L12 10.5' fill='white' />
				<path
					d='M9 4.5V9L12 10.5'
					{...{
						className: svgElementClassName,
					}}
					strokeLinecap='round'
					strokeLinejoin='round'
					strokeWidth='2'
				/>
			</g>
			<defs>
				<clipPath id='clip0_522_24843'>
					<rect width='18' height='18' fill='white' />
				</clipPath>
			</defs>
		</svg>
	</div>
);

export const CalendarIcon = ({
	svgElementClassName,
	applyToSvgEl = false,
	className,
	styles,
}: TComponentBasicProps) => (
	<div
		{...{
			style: styles,
			className,
		}}>
		<svg
			viewBox='0 0 19 19'
			{...(applyToSvgEl
				? {
						className: svgElementClassName,
				  }
				: {
						className: 'fill-none',
				  })}
			xmlns='http://www.w3.org/2000/svg'>
			<path
				d='M14.75 3.5H4.25C3.42157 3.5 2.75 4.17157 2.75 5V15.5C2.75 16.3284 3.42157 17 4.25 17H14.75C15.5784 17 16.25 16.3284 16.25 15.5V5C16.25 4.17157 15.5784 3.5 14.75 3.5Z'
				{...{
					className: svgElementClassName,
				}}
				strokeLinecap='round'
				strokeLinejoin='round'
				strokeWidth='2'
			/>
			<path
				d='M12.5 2V5'
				{...{
					className: svgElementClassName,
				}}
				strokeLinecap='round'
				strokeLinejoin='round'
				strokeWidth='2'
			/>
			<path
				d='M6.5 2V5'
				{...{
					className: svgElementClassName,
				}}
				strokeLinecap='round'
				strokeLinejoin='round'
				strokeWidth='2'
			/>
			<path
				d='M2.75 8H16.25'
				{...{
					className: svgElementClassName,
				}}
				strokeLinecap='round'
				strokeLinejoin='round'
				strokeWidth='2'
			/>
			<path
				d='M6.5 11H6.5075'
				{...{
					className: svgElementClassName,
				}}
				strokeLinecap='round'
				strokeLinejoin='round'
				strokeWidth='2'
			/>
			<path
				d='M9.5 11H9.5075'
				{...{
					className: svgElementClassName,
				}}
				strokeLinecap='round'
				strokeLinejoin='round'
				strokeWidth='2'
			/>
			<path
				d='M12.5 11H12.5075'
				{...{
					className: svgElementClassName,
				}}
				strokeLinecap='round'
				strokeLinejoin='round'
				strokeWidth='2'
			/>
			<path
				d='M6.5 14H6.5075'
				{...{
					className: svgElementClassName,
				}}
				strokeLinecap='round'
				strokeLinejoin='round'
				strokeWidth='2'
			/>
			<path
				d='M9.5 14H9.5075'
				{...{
					className: svgElementClassName,
				}}
				strokeLinecap='round'
				strokeLinejoin='round'
				strokeWidth='2'
			/>
			<path
				d='M12.5 14H12.5075'
				{...{
					className: svgElementClassName,
				}}
				strokeLinecap='round'
				strokeLinejoin='round'
				strokeWidth='2'
			/>
		</svg>
	</div>
);

export const DocumentsIcon = ({
	svgElementClassName,
	applyToSvgEl = false,
	className,
	styles,
}: TComponentBasicProps) => (
	<div
		{...{
			style: styles,
			className,
		}}>
		<svg
			viewBox='0 0 24 24'
			{...(applyToSvgEl
				? {
						className: svgElementClassName,
				  }
				: {
						className: 'fill-none',
				  })}
			xmlns='http://www.w3.org/2000/svg'>
			<path
				d='M14.4064 14.8714H7.78809'
				{...{
					className: svgElementClassName,
				}}
				strokeLinecap='round'
				strokeLinejoin='round'
				strokeWidth='2'
			/>
			<path
				d='M14.4064 11.0335H7.78809'
				{...{
					className: svgElementClassName,
				}}
				strokeLinecap='round'
				strokeLinejoin='round'
				strokeWidth='2'
			/>
			<path
				d='M10.3137 7.20492H7.78833'
				{...{
					className: svgElementClassName,
				}}
				strokeLinecap='round'
				strokeLinejoin='round'
				strokeWidth='2'
			/>
			<path
				fillRule='evenodd'
				clipRule='evenodd'
				d='M14.5828 2.52051C14.5828 2.52051 7.54557 2.52417 7.53457 2.52417C5.00457 2.53976 3.43799 4.20442 3.43799 6.74359V15.1733C3.43799 17.7253 5.01649 19.3963 7.56849 19.3963C7.56849 19.3963 14.6048 19.3936 14.6167 19.3936C17.1467 19.378 18.7142 17.7124 18.7142 15.1733V6.74359C18.7142 4.19159 17.1348 2.52051 14.5828 2.52051Z'
				{...{
					className: svgElementClassName,
				}}
				strokeLinecap='round'
				strokeLinejoin='round'
				strokeWidth='2'
			/>
		</svg>
	</div>
);

export const SearchIcon = ({
	svgElementClassName,
	applyToSvgEl = false,
	className,
	styles,
}: TComponentBasicProps) => (
	<div
		{...{
			style: styles,
			className,
		}}>
		<svg
			viewBox='0 0 20 20'
			{...(applyToSvgEl
				? {
						className: svgElementClassName,
				  }
				: {
						className: 'fill-none',
				  })}
			xmlns='http://www.w3.org/2000/svg'>
			<path
				d='M8.60938 15.3438C12.0525 15.3438 14.8438 12.5525 14.8438 9.10938C14.8438 5.66622 12.0525 2.875 8.60938 2.875C5.16622 2.875 2.375 5.66622 2.375 9.10938C2.375 12.5525 5.16622 15.3438 8.60938 15.3438Z'
				fillRule='evenodd'
				clipRule='evenodd'
				{...{
					className: svgElementClassName,
				}}
				strokeLinecap='round'
				strokeLinejoin='round'
				strokeWidth='2'
			/>
			<path
				d='M13.0178 13.518L16.6249 17.125'
				fillRule='evenodd'
				clipRule='evenodd'
				{...{
					className: svgElementClassName,
				}}
				strokeLinecap='round'
				strokeLinejoin='round'
				strokeWidth='2'
			/>
		</svg>
	</div>
);

export const CompassIcon = ({
	svgElementClassName,
	applyToSvgEl,
	className,
	styles,
}: TComponentBasicProps) => (
	<div
		{...{
			style: styles,
			className,
		}}>
		<svg
			{...(applyToSvgEl
				? {
						className: svgElementClassName,
				  }
				: {
						className: 'fill-none',
				  })}
			viewBox='0 0 25 24'
			xmlns='http://www.w3.org/2000/svg'>
			<path
				fillRule='evenodd'
				clipRule='evenodd'
				d='M8.77002 14.9524L10.3627 9.86319L15.4519 8.27051L13.8593 13.3598L8.77002 14.9524Z'
				{...{
					className: svgElementClassName,
				}}
				strokeWidth='1.5'
				strokeLinecap='round'
				strokeLinejoin='round'
			/>
			<circle
				cx='12.111'
				cy='11.611'
				r='9.61098'
				{...{
					className: svgElementClassName,
				}}
				strokeWidth='1.5'
				strokeLinecap='round'
				strokeLinejoin='round'
			/>
		</svg>
	</div>
);

export const TwoUsersIcon = ({
	svgElementClassName,
	applyToSvgEl,
	className,
	styles,
}: TComponentBasicProps) => (
	<div
		{...{
			style: styles,
			className,
		}}>
		<svg
			{...(applyToSvgEl
				? {
						className: svgElementClassName,
				  }
				: {
						className: 'fill-none',
				  })}
			viewBox='0 0 24 24'
			xmlns='http://www.w3.org/2000/svg'>
			<path
				d='M16.02 10.9138C17.841 10.9138 19.317 9.43782 19.317 7.61682C19.317 5.79682 17.841 4.31982 16.02 4.31982'
				{...{
					className: svgElementClassName,
				}}
				fillRule='evenodd'
				clipRule='evenodd'
				strokeWidth='1.5'
				strokeLinecap='round'
				strokeLinejoin='round'
			/>
			<path
				d='M17.5361 14.4966C18.0801 14.5336 18.6201 14.6116 19.1531 14.7296C19.8921 14.8766 20.7821 15.1796 21.0981 15.8426C21.3001 16.2676 21.3001 16.7626 21.0981 17.1876C20.7831 17.8506 19.8921 18.1536 19.1531 18.3056'
				{...{
					className: svgElementClassName,
				}}
				fillRule='evenodd'
				clipRule='evenodd'
				strokeWidth='1.5'
				strokeLinecap='round'
				strokeLinejoin='round'
			/>
			<path
				d='M9.59149 15.2065C13.2815 15.2065 16.4335 15.7655 16.4335 17.9985C16.4335 20.2325 13.3015 20.8105 9.59149 20.8105C5.90149 20.8105 2.75049 20.2525 2.75049 18.0185C2.75049 15.7845 5.88149 15.2065 9.59149 15.2065Z'
				{...{
					className: svgElementClassName,
				}}
				fillRule='evenodd'
				clipRule='evenodd'
				strokeWidth='1.5'
				strokeLinecap='round'
				strokeLinejoin='round'
			/>
			<path
				d='M9.59152 12.019C7.15752 12.019 5.20752 10.068 5.20752 7.634C5.20752 5.201 7.15752 3.25 9.59152 3.25C12.0255 3.25 13.9765 5.201 13.9765 7.634C13.9765 10.068 12.0255 12.019 9.59152 12.019Z'
				{...{
					className: svgElementClassName,
				}}
				fillRule='evenodd'
				clipRule='evenodd'
				strokeWidth='1.5'
				strokeLinecap='round'
				strokeLinejoin='round'
			/>
		</svg>
	</div>
);

export const AddUserIcon = ({
	svgElementClassName,
	applyToSvgEl,
	className,
	styles,
}: TComponentBasicProps) => (
	<div
		{...{
			style: styles,
			className,
		}}>
		<svg
			{...(applyToSvgEl
				? {
						className: svgElementClassName,
				  }
				: {
						className: 'fill-none',
				  })}
			viewBox='0 0 20 20'
			xmlns='http://www.w3.org/2000/svg'>
			<path
				d='M8.23116 12.6719C5.02783 12.6719 2.29199 13.156 2.29199 15.096C2.29199 17.0352 5.01033 17.5377 8.23116 17.5377C11.4345 17.5377 14.1703 17.0527 14.1703 15.1135C14.1703 13.1744 11.452 12.6719 8.23116 12.6719Z'
				{...{
					className: svgElementClassName,
				}}
				fillRule='evenodd'
				clipRule='evenodd'
				strokeWidth='1.5'
				strokeLinecap='round'
				strokeLinejoin='round'
			/>
			<path
				{...{
					className: svgElementClassName,
				}}
				fillRule='evenodd'
				clipRule='evenodd'
				strokeWidth='1.5'
				strokeLinecap='round'
				strokeLinejoin='round'
				d='M8.23147 9.90484C10.3448 9.90484 12.0381 8.21067 12.0381 6.09817C12.0381 3.98484 10.3448 2.2915 8.23147 2.2915C6.11897 2.2915 4.4248 3.98484 4.4248 6.09817C4.4248 8.21067 6.11897 9.90484 8.23147 9.90484Z'
			/>
			<path
				d='M16.0036 7.22412V10.5658'
				{...{
					className: svgElementClassName,
				}}
				fillRule='evenodd'
				clipRule='evenodd'
				strokeWidth='1.5'
				strokeLinecap='round'
				strokeLinejoin='round'
			/>
			<path
				d='M17.7081 8.89469H14.2998'
				{...{
					className: svgElementClassName,
				}}
				fillRule='evenodd'
				clipRule='evenodd'
				strokeWidth='1.5'
				strokeLinecap='round'
				strokeLinejoin='round'
			/>
		</svg>
	</div>
);

export const CheckMarkIcon = ({
	svgElementClassName,
	applyToSvgEl = false,
	className,
	styles,
}: TComponentBasicProps) => (
	<div
		{...{
			style: styles,
			className,
		}}>
		<svg
			viewBox='0 0 24 24'
			{...(applyToSvgEl
				? {
						className: svgElementClassName,
				  }
				: {
						className: 'fill-none',
				  })}
			xmlns='http://www.w3.org/2000/svg'>
			<path
				d='M7.5364 11.73C7.18492 11.3785 6.61508 11.3785 6.2636 11.73C5.91213 12.0814 5.91213 12.6513 6.2636 13.0027L9.53043 16.2696C9.8819 16.621 10.4517 16.621 10.8032 16.2696L18.5364 8.5364C18.8879 8.18492 18.8879 7.61508 18.5364 7.2636C18.1849 6.91213 17.6151 6.91213 17.2636 7.2636L10.1668 14.3604L7.5364 11.73Z'
				{...{
					className: svgElementClassName,
				}}
				strokeLinejoin='round'
				strokeLinecap='round'
				strokeWidth='1.67'
			/>
		</svg>
	</div>
);

export const CrossMarkIcon = ({
	svgElementClassName,
	applyToSvgEl = false,
	className,
	styles,
}: TComponentBasicProps) => (
	<div
		{...{
			style: styles,
			className,
		}}>
		<svg
			viewBox='0 0 24 24'
			{...(applyToSvgEl
				? {
						className: svgElementClassName,
				  }
				: {
						className: 'fill-none',
				  })}
			xmlns='http://www.w3.org/2000/svg'>
			<path
				d='M10.6712 12L7.27521 8.60406C6.90826 8.23711 6.90826 7.64216 7.27521 7.27521C7.64216 6.90826 8.23711 6.90826 8.60406 7.27521L12 10.6712L15.3959 7.27521C15.7629 6.90826 16.3578 6.90826 16.7248 7.27521C17.0917 7.64216 17.0917 8.23711 16.7248 8.60406L13.3288 12L16.7248 15.3959C17.0917 15.7629 17.0917 16.3578 16.7248 16.7248C16.3578 17.0917 15.7629 17.0917 15.3959 16.7248L12 13.3288L8.60406 16.7248C8.23711 17.0917 7.64216 17.0917 7.27521 16.7248C6.90826 16.3578 6.90826 15.7629 7.27521 15.3959L10.6712 12Z'
				{...{
					className: svgElementClassName,
				}}
				strokeLinejoin='round'
				strokeLinecap='round'
				strokeWidth='1.67'
			/>
		</svg>
	</div>
);

export const DropFileIcon = ({
	svgElementClassName,
	applyToSvgEl = false,
	className,
	styles,
}: TComponentBasicProps) => (
	<div
		{...{
			style: styles,
			className,
		}}>
		<svg
			viewBox='0 0 24 24'
			{...(applyToSvgEl
				? {
						className: svgElementClassName,
				  }
				: {
						className: 'fill-none',
				  })}
			xmlns='http://www.w3.org/2000/svg'>
			<path
				d='M13.2441 6.13013L12.4121 5.39132V6.504V14.496C12.4121 14.7239 12.2279 14.908 12.0001 14.908C11.7895 14.908 11.6121 14.7415 11.6121 14.496V6.504V5.39717L10.7815 6.12882L7.75754 8.79282L7.75215 8.79757L7.7469 8.80247C7.58699 8.95173 7.34757 8.92773 7.22811 8.78071L7.21729 8.76739L7.20559 8.75484C7.0632 8.60228 7.06886 8.35118 7.24131 8.20029L7.24132 8.2003L7.24399 8.19793L11.732 4.21392L11.7321 4.21401L11.7403 4.20639C11.8564 4.0986 12.0309 4.06927 12.1911 4.14557L12.2681 4.21392L16.7561 8.19793L16.7561 8.19794L16.7588 8.20029C16.9325 8.35224 16.9405 8.6126 16.807 8.76765C16.656 8.93922 16.4055 8.94462 16.2532 8.80248L16.2533 8.80236L16.2441 8.79413L13.2441 6.13013ZM5.30806 18.192V18.692H5.80806H18.1921H18.6921V18.192V16.896C18.6921 16.6854 18.8586 16.508 19.1041 16.508C19.3319 16.508 19.4921 16.6682 19.4921 16.896V19.104C19.4921 19.3167 19.3231 19.492 19.1041 19.492H4.89606C4.6922 19.492 4.50806 19.3079 4.50806 19.104V16.896C4.50806 16.6769 4.68335 16.508 4.89606 16.508C5.14153 16.508 5.30806 16.6854 5.30806 16.896V18.192Z'
				{...{
					className: svgElementClassName,
				}}
				fillRule='evenodd'
				clipRule='evenodd'
				strokeWidth='1.5'
				strokeLinecap='round'
				strokeLinejoin='round'
			/>
			<path
				d='M12.9121 6.504V14.496C12.9121 15 12.5041 15.408 12.0001 15.408C11.4961 15.408 11.1121 15 11.1121 14.496V6.504L8.08806 9.168C7.72806 9.504 7.15206 9.48 6.84006 9.096C6.50406 8.736 6.52806 8.16 6.91206 7.824L11.4001 3.84C11.7361 3.528 12.2401 3.528 12.6001 3.816C12.6001 3.84 12.6001 3.84 12.6001 3.84L17.0881 7.824C17.4721 8.16 17.4961 8.736 17.1841 9.096C16.8481 9.48 16.2721 9.504 15.9121 9.168L12.9121 6.504ZM18.1921 16.896C18.1921 16.392 18.6001 16.008 19.1041 16.008C19.6081 16.008 19.9921 16.392 19.9921 16.896V19.104C19.9921 19.584 19.6081 19.992 19.1041 19.992H4.89606C4.41606 19.992 4.00806 19.584 4.00806 19.104V16.896C4.00806 16.392 4.41606 16.008 4.89606 16.008C5.40006 16.008 5.80806 16.392 5.80806 16.896V18.192H18.1921V16.896Z'
				{...{
					className: svgElementClassName,
				}}
				fillRule='evenodd'
				clipRule='evenodd'
				strokeWidth='1.5'
				strokeLinecap='round'
				strokeLinejoin='round'
			/>
		</svg>
	</div>
);
