import Image from 'next/image';
import { TIconProps } from '../utils/types';

const Logo = ({ title, color, dimensions }: TIconProps) => {
	return (
		<div className='flex-[1] flex justify-center flex-col items-center w-[260px] h-full'>
			<Image
				{...{
					src: '/images/logo/logo.png',
					height: dimensions?.height ?? 100,
					width: dimensions?.width ?? 100,
					alt: 'Kitui Gov logo',
				}}
			/>

			{title ? (
				<p
					className={`mt-[12px] font-bold text-[20px] tracking-[-.5%] leading-[27.28px] text-gray-body-text`}
					style={{
						...(color
							? {
									backgroundColor: color.bg,
									color: color.text,
							  }
							: {}),
					}}>
					{title}
				</p>
			) : null}
		</div>
	);
};

export default Logo;
