import { TNodes } from '../utils/types';

export const SideBarComponents = ({
	onClickHandler,
	children,
	title,
}: {
	title: string;
	onClickHandler: () => any;
} & TNodes) => (
	<div
		{...{
			className: `h-[46px] mx-[2px] p-[12px] flex gap-[8px] my-[2px] selection:bg-inherit hover:bg-fon-hover align-center rounded-[6px] cursor-pointer text-body-bg dark:text-foundation`,
			onClick: onClickHandler,
		}}>
		{children}
		<p className=''>{title}</p>
	</div>
);
