import { PlusIcon } from '@radix-ui/react-icons';
import { THeaderBtn } from '../utils/types';

export default function AddJobsBtn({
	Icon = PlusIcon,
	text,
	present,
	action,
}: THeaderBtn) {
	return (
		<div
			className='w-fit flex items-center cursor-pointer gap-[4px] rounded-[8px] bg-dev-accent border-border-color selection:bg-inherit shadow-btnBoxShadow px-[16px] py-[10px] border'
			onClick={action!}
			role='button'>
			<div className=' text-body-bg dark:text-white'>
				{
					<Icon
						width={20}
						height={20}
						color='white'
						{...{
							styles: {
								width: '24px',
								height: '24px',
							},
							svgElementClassName: 'stroke-white',
						}}
					/>
				}
			</div>
			<h2 className='text-white font-semibold text-[14px] leading-[20px]'>
				{text}
			</h2>
		</div>
	);
}
