import {
	ResponsiveContainer,
	CartesianGrid,
	XAxis,
	YAxis,
	AreaChart,
	Area,
} from 'recharts';

import { TooltipComponent } from '../others/CommonComponents';
import { TGraphUtilsInterface, TNodes } from '../utils/types';
import { tickFormatter } from '@/utils';

export const LineGraphComponent = ({
	withAxisLines = { x: true, y: true },
	xAxisLabel,
	yAxisLabel,
	children,
	data,
}: TNodes & TGraphUtilsInterface) => (
	<ResponsiveContainer
		{...{
			width: '100%',
			height: '100%',
		}}>
		<AreaChart
			{...{
				margin: { top: 5, right: 30, left: 20, bottom: 5 },
				// height: 360,
				// width: 730,
				data,
			}}>
			<XAxis
				{...{
					tick: {
						fill: 'var(--body)',
						fontSize: 12,
					},
					dataKey: 'month',
					label: {
						position: 'insideBottom',
						value: xAxisLabel ?? 'Month',
						offset: -4,
					},
					height: 40,
					...(!withAxisLines.x
						? {
								axisLine: false,
						  }
						: {}),
				}}
			/>
			<YAxis
				{...{
					tick: {
						fill: 'var(--body)',
						fontSize: 12,
					},
					dataKey: 'count',

					label: {
						position: 'insideLeft',
						value: yAxisLabel ?? 'Members',
						offset: -4,
						angle: -90,
					},
					...(!withAxisLines.y
						? {
								axisLine: false,
						  }
						: {}),

					className: 'text-body',
					tickFormatter,
					name: 'name',
				}}
			/>

			<CartesianGrid
				{...{
					className: 'stroke:fwd dark:stroke-fwd-darker',
					...(!withAxisLines.y ? { vertical: false } : {}),
				}}
			/>
			{TooltipComponent}
			{children}
			<Area
				stroke='var(--accent-color)'
				className='w-full h-full'
				fill='var(--accent-light)'
				{...{
					strokeWidth: '4px',
				}}
				dataKey='count'
				type='natural'
			/>
		</AreaChart>
	</ResponsiveContainer>
);
