'use client';

import { ChevronDownIcon, ExitIcon } from '@radix-ui/react-icons';
import { useRouter } from 'next/navigation';
import { getCookie } from 'cookies-next';
import { useState } from 'react';

import { BASE_URL, COOKIE_KEYS, NAV_URLS } from '../utils/constants';
import { SideBarComponents } from '../others/SideBarComponents';
import { DropdownMenuTrigger } from '../ui/dropdown-menu';
import { Logout } from '../utils/server-functions';

import {
	DropDownWrapperCustomComponent,
	CustomLinkComponentWithSubLinks,
	CustomLinkComponent,
	HumbuggerComponent,
	Avatar,
	DropdownCustomComponentRadio,
} from '../others/CommonComponents';
import { TUSER } from '../utils/types';
import { SupportIcon } from '../icons';

export default function Header() {
	const userCookie = getCookie(COOKIE_KEYS.user);

	const userInfo: TUSER | null = userCookie ? JSON.parse(userCookie) : null;

	const [isNavOpen, setIsNavOpen] = useState(false);

	const toggleHumbuggerOpen = () => setIsNavOpen((prev) => !prev);

	const router = useRouter();

	return (
		<nav
			className={`flex justify-between gap-[24px] selection:bg-inherit w-full`}>
			{/* begin of left section of header  */}
			<div className=' hidden lg:block md:p-[10px]'>
				<p className='font-bold text-[20px] leading-[27.28px] tracking-[-.5%]'>
					Welcome, {userInfo?.username ?? ''}
				</p>
				<p className='leading-[24px] font-normal text-[14px] text-navy'>
					See the latest job applications
				</p>
			</div>

			<div className='flex flex-col md:hidden mx-[16px]'>
				<HumbuggerComponent
					{...{
						onChangeHandler: toggleHumbuggerOpen,
						opened: isNavOpen,
					}}
				/>

				<div
					className={`transition-all duration-700 ${
						isNavOpen ? '' : 'hidden relative'
					}`}>
					<div className='absolute left-0  flex-[5] pt-[10px] my-[32px] h-fit bg-sidebar-bg-light p-[6px] border-r-[0.2px] border-small-card-bg dark:bg-sidebar-bg rounded-[8px]'>
						{NAV_URLS.map((urlInfo, index) => {
							return urlInfo?.suburls && urlInfo?.suburls?.length > 0 ? (
								<CustomLinkComponentWithSubLinks
									{...{
										onClick: toggleHumbuggerOpen,
										...urlInfo,
									}}
									key={index}
								/>
							) : (
								<CustomLinkComponent
									{...{
										onClick: toggleHumbuggerOpen,
										...urlInfo,
									}}
									key={index}
								/>
							);
						})}

						<div className='my-[2px]'>
							{[
								{
									onClickHandler: () => {},
									title: 'Support',
									iconPath: (
										<div className='w-[20px] h-[20px] text-body-bg dark:text-white'>
											<SupportIcon
												{...{
													styles: {
														width: '24px',
														height: '24px',
													},
													// svgElementClassName: routePath.startsWith(url)
													// 	? 'stroke-white'
													// 	: 'dark:stroke-sidebar-bg-light stroke-sidebar-bg',
													svgElementClassName:
														'dark:stroke-sidebar-bg-light stroke-sidebar-bg',
												}}
											/>
										</div>
									),
								},

								{
									title: 'Logout',
									iconPath: (
										<div className='w-[20px] h-[20px] text-body-bg dark:text-white'>
											<ExitIcon width={20} height={20} />
										</div>
									),
									onClickHandler: async () => await Logout(),
								},
							].map(({ title, iconPath, onClickHandler }, key) => (
								<SideBarComponents
									key={`sideb-${key}`}
									{...{
										onClickHandler,
										title,
									}}>
									{iconPath}
								</SideBarComponents>
							))}
						</div>
					</div>
				</div>
			</div>

			{/* end of left section of the header  */}

			{/* right section of the header */}
			<div className='flex justify-end gap-[20px] flex-1 items-center pr-[10px]'>
				{/* avatar section starts here */}

				<DropDownWrapperCustomComponent
					{...{
						components: (
							<DropdownMenuTrigger asChild>
								<div className='flex items-center'>
									<Avatar
										{...{
											name: userInfo?.username ?? '',
											classNames: 'w-[40px] h-[40px]',
										}}
									/>

									<div className='w-[20px] h-auto text-body-bg dark:text-white'>
										<ChevronDownIcon width={20} height={20} />
									</div>
								</div>
							</DropdownMenuTrigger>
						),
					}}>
					<DropdownCustomComponentRadio
						{...{
							onChangeHandler: (value) => router.push(`${BASE_URL}/profile`),
							currPageSize: '',
							data: [
								{
									onChangeHandler: () => router.push(`${BASE_URL}/profile`),
									label: 'Profile',
								},
								{ label: 'Logout', onChangeHandler: () => Logout() },
							].map(({ label, onChangeHandler }) => ({
								onChangeHandler,
								label,
							})),
						}}
					/>
				</DropDownWrapperCustomComponent>

				{/* avatar section ends here  */}
			</div>
			{/* end of right section of the header */}
		</nav>
	);
}
