type RecordProps = {
	table: any;
};
export default function PaginationRecordsComponent(props: RecordProps) {
	return (
		<div className='w-fit p-[8px] bg-sidebar-bg-light dark:bg-small-card-bg text-body dark:text-white'>
			<select
				value={props.table.getState().pagination.pageSize}
				onChange={(e) => {
					props.table.setPageSize(Number(e.target.value));
				}}
				className='bg-sidebar-bg-light dark:bg-small-card-bg text-body dark:text-sidebar-bg-light'>
				{[10, 20, 30, 40, 50].map((pageSize) => (
					<option
						key={`pagination-${pageSize}`}
						value={pageSize}
						className='bg-sidebar-bg-light dark:bg-small-card-bg text-body dark:text-sidebar-bg-light'>
						Show {pageSize}
					</option>
				))}
			</select>
		</div>
	);
}
