import { SearchIcon } from '../icons';
import { TSearchProps } from '../utils/types';

export default function ({
	title = "I'm looking for...",
	onChangeHandler,
	value,
}: TSearchProps) {
	return (
		<div
			{...{
				className: `relative w-[400px] mx-[6px] cursor-pointer`,
			}}>
			<div className='absolute top-[calc(calc(100%-24px)/2)] left-[4px]'>
				<SearchIcon
					{...{
						styles: {
							width: '24px',
							height: '24px',
						},
						svgElementClassName: 'stroke-[1.67px] stroke-search-icon-color',
					}}
				/>
			</div>

			<input
				className='rounded-[8px] border px-[14px] py-[10px] pl-[26px] placeholder:text-[#c3c3c3] w-full focus:border-[1px] focus:border-dev-accent h-[44px] outline-none shadow-btnBoxShadow'
				{...{
					onChange: (value) =>
						onChangeHandler ? onChangeHandler(value.currentTarget.value) : null,
					placeholder: title,
					type: 'text',
					value,
				}}
			/>
		</div>
	);
}
