'use client';
import { ExitIcon } from '@radix-ui/react-icons';
import dynamic from 'next/dynamic';

import { BASE_URL, NAV_URLS } from '../utils/constants';
import {
	CustomLinkComponentWithSubLinks,
	CustomLinkComponent,
	Loader,
	//   SideBarComponents,
} from '../others/CommonComponents';
import { SupportIcon } from '../icons';
import { Logout } from '../utils/server-functions';

const Logo = dynamic(() => import('@/components/others/Logo'), {
	ssr: false,
	loading: () => (
		<div className='text-sidebar-bg dark:text-white h-[120px] w-full'>
			<Loader
				{...{
					title: 'Loading logo...',
				}}
			/>
		</div>
	),
});

const SideBarComponents = dynamic(
	(() =>
		import('../others/SideBarComponents').then(
			({ SideBarComponents }) => SideBarComponents
		)) as any,
	{ ssr: false }
) as any;

export default function SideBar() {
	return (
		<aside className='w-full min-h-full h-auto justify-between bg-sidebar-bg-light p-[6px] border-[.5px] border-gray-200 flex flex-col shadow-sidebarShadow'>
			<div className='flex flex-col mt-[32px] selection:bg-inherit'>
				{/* Logo section  */}
				<div className='flex justify-center h-[169px]'>
					<Logo
						{...{
							title: `Kitui County`,
							color: {
								text: '',
								bg: '',
							},
						}}
					/>
				</div>
				{/* end of logo section  */}

				{/* link section */}
				<div className='h-fit'>
					{NAV_URLS.map((urlInfo, index) => {
						return urlInfo?.suburls && urlInfo?.suburls?.length > 0 ? (
							<CustomLinkComponentWithSubLinks {...urlInfo} key={index} />
						) : (
							<CustomLinkComponent {...urlInfo} key={index} />
						);
					})}
				</div>
			</div>
			{/* end of link section  */}

			{/* bottom section  */}
			<div className='my-[4px]'>
				{/* other links */}

				<CustomLinkComponent
					{...{
						url: `${BASE_URL}/support`,
						Icon: SupportIcon,
						name: 'Support',
					}}
				/>

				<div className='my-[2px]'>
					<div
						className='min-h-[46px] h-auto mx-[2px] p-[12px] flex items-center hover:bg-dev-accent hover:text-white gap-[8px] my-[2px] selection:bg-inherit align-center rounded-[6px] cursor-pointer text-body-bg'
						onClick={(e) => Logout()}>
						<div className='w-fit h-fit text-body-bg dark:text-white'>
							<ExitIcon width={24} height={24} className='text-inherit' />
						</div>

						<p className='text-inherit'>Logout</p>
					</div>
				</div>
			</div>
		</aside>
	);
}
