import { Avatar } from '../others/CommonComponents';
import { TTaskType } from '../utils/types';

export default function ({ name, time, title }: Partial<TTaskType>) {
	return (
		<div className='border-b-[1px] border-fwd-darker flex flex-row gap-[8px] pt-[16px] pb-[10px] w-full h-fit items-center'>
			<div className='flex-[1]'>
				<Avatar {...{ name: name ?? '' }} />
			</div>

			<div className='flex-[10]'>
				<div className='flex justify-between'>
					<p className='text-gray-body-text text-[14px] leading-[24px] font-normal'>
						{name}
					</p>
					<div className='text-gray-body-text leading-[20px] text-[12px] font-semibold'>
						{time?.substring(0, 20)} ago
					</div>
				</div>

				<p className='text-body-text-gray-500'>{title?.substring(0, 24)}</p>
			</div>
		</div>
	);
}
