import Task from './Task';
import { Loader } from '../others/CommonComponents';
import { Application, TLinegraphReusableComponent } from '../utils/types';
import { formatDistanceStrict } from 'date-fns';

export default function ({
	applications,
	isLoading,
	isError,
}: { applications: Application[] } & Pick<
	TLinegraphReusableComponent,
	'isError' | 'isLoading'
>) {
	return (
		<div className='p-[16px] bg-sidebar-bg-light dark:bg-small-card-bg sm:overflow-auto sm:h-[460px] rounded-[6px] shadow-sidebarShadow'>
			<div className='py-[8px]'>
				<h1 className='font-bold text-[16px] leading-[24px] text-title-text-color'>
					Recent notifications
				</h1>
			</div>

			<div className='flex flex-col w-full h-full'>
				{isLoading ? (
					<div className='w-full h-full'>
						<Loader />
					</div>
				) : isError ? (
					<div className='w-full h-full'>
						<Loader {...{ title: 'Failed to fetch data' }} />
					</div>
				) : (
					applications.map((item, index) => (
						<Task
							{...{
								time: formatDistanceStrict(item.createdAt, new Date(), {
									addSuffix: false,
								}),
								name: item.user?.username,
								title: item.job?.title,
							}}
							key={`task-${index}`}
						/>
					))
				)}
			</div>
		</div>
	);
}
