import { DropdownMenuTrigger } from '../ui/dropdown-menu';
import { FunnelIcon } from '../icons';

export function FilterIconComponent() {
	return (
		<DropdownMenuTrigger asChild>
			<div className='flex px-[16px] py-[10px] border border-border-color rounded-[8px] gap-[8px] shadow-btnBoxShadow items-center justify-center selection:bg-inherit cursor-pointer'>
				<FunnelIcon
					{...{
						styles: {
							width: '20px',
							height: '20px',
						},
						svgElementClassName: 'stroke-filter-stroke-color',
					}}
				/>

				<p className='text-center font-normal text-filter-stroke-color text-[14px] leading-[24px]'>
					Filters
				</p>
			</div>
		</DropdownMenuTrigger>
	);
}
