import { TDashboardTypes } from './types';
import {
	ApplicantsIcon,
	TwoUsersIcon,
	HomeIcon,
	WorkIcon,
	ArrowDownIcon,
} from '../icons';

export const BASE_ASSET_URL = '/images';

export const BASE_URL = '/dashboard';

export const NAV_URLS: TDashboardTypes[] = [
	{
		Icon: HomeIcon,
		url: `${BASE_URL}`,
		name: 'Dashboard',
		suburls: [],
		perms: [],
	},

	{
		IconForOpened: ArrowDownIcon,
		EndIcon: ArrowDownIcon,
		url: `${BASE_URL}/jobs`,
		Icon: WorkIcon,
		name: 'Jobs',
		perms: [],
		suburls: [
			{
				name: 'Create a job',
				url: 'create',
				perms: [],
			},

			{
				name: 'Open jobs',
				url: 'open',
				perms: [],
			},

			{
				name: 'Closed jobs',
				url: 'closed',
				perms: [],
			},
		],
	},
	{
		url: `${BASE_URL}/applicants`,
		IconForOpened: ArrowDownIcon,
		EndIcon: ArrowDownIcon,
		Icon: ApplicantsIcon,
		name: 'Applicants',
		perms: [],
		suburls: [
			{
				url: `new-applicants`,
				name: 'New applications',
				perms: [],
			},
			{
				url: `underreview`,
				name: 'Under review',
				perms: [],
			},
			{
				url: `shortlisted`,
				name: 'Shortlisted applicants',
				perms: [],
			},
			{
				url: `rejected`,
				name: 'Rejected applicants',
				perms: [],
			},

			{
				url: `awarded`,
				name: 'Awarded applicants',
				perms: [],
			},
		],
	},

	// {
	// 	url: `${BASE_URL}/departments`,
	// 	Icon: CompassIcon,
	// 	name: 'Departments',
	// 	suburls: [],
	// 	perms: [],
	// },

	// {
	// 	url: `${BASE_URL}/comments`,
	// 	Icon: MessageIcon,
	// 	name: 'Comments',
	// 	suburls: [],
	// 	perms: [],
	// },

	{
		url: `${BASE_URL}/staff`,
		name: 'Manage users',
		Icon: TwoUsersIcon,
		suburls: [],
		perms: [],
	},
];

export const NumberPrecisionAccronymn = [
	{ suffix: 'T', threshold: 1e12 },
	{ suffix: 'B', threshold: 1e9 },
	{ suffix: 'M', threshold: 1e6 },
	{ suffix: 'K', threshold: 1e3 },
	{ suffix: '', threshold: 1 },
];

export const PLATFORM_PREFIX_NAME = 'Kitui';
export const PLATFORM_SUFFIX_NAME = 'County gov';

export const FieldsToExcludeInFilter = ['actions', 'id'];

export const PAGE_SIZE: string[] = ['5', '10', '25', '50', '100'];

export const COOKIE_KEYS = {
	network: 'net_',
	campus: 'camp_',
	user: 'u_',
	auth: 'a_',
};

export const URL_SEARCH_PARAMS = { redirect: 'redir_uri' };

export enum JobTypes {
	'Attachment' = 'Attachment',
	'Internship' = 'Internship',
	'Permanent' = 'Permanent',
	'Contract' = 'Contract',
}

export enum JobTypesEnum {
	'Attachment' = 'Attachment',
	'Permanent' = 'Permanent',
	'Contract' = 'Contract',
}

export enum ApplicantTabsEnum {
	complete_assesment = 'complete_assesment',
	application_details = 'application_details',
	review_status = 'review_status',
}

export enum UserEnum {
	suspended = 'suspended',
	active = 'active',
}
export enum JobOptionsEnum {
	'Close Job' = 'Close Job',
	'Edit Job' = 'Edit Job',
}

export enum UserOptionsEnum {
	'Activate' = 'Activate',
	'Suspend' = 'Suspend',
	'Edit' = 'Edit',
}

export const BACKEND_URL = 'https://kitui-jobs-portal.up.railway.app';
