import { StrapiRequestParams } from 'strapi-sdk-js';

import { NetworkLists } from '@/app/dashboard/jobs/types';
import { ColumnDef } from '@tanstack/react-table';
import { Dispatch, SetStateAction } from 'react';
import { JobOptionsEnum, JobTypes, UserOptionsEnum } from './constants';
import { QueryObserverResult } from 'react-query';

export enum EPerms {
	Director = 'Director',
	Manager = 'Manager',
	Admin = 'Admin',
}

export type TDashboardTypes = {
	suburls?: TDashboardTypes[];
	IconForOpened?: (props: TComponentBasicProps) => React.JSX.Element;
	EndIcon?: (props: TComponentBasicProps) => React.JSX.Element;
	Icon?: (props: TComponentBasicProps) => React.JSX.Element;
	onClick?: () => void;
	perms?: EPerms[];
	name: string;
	url: string;
};

export type TTableData = {
	status: 'pending' | 'processing' | 'success' | 'failed';
	amount: number;
	email: string;
	id: string;
};
export type TColumnStaffDefinition = {
	accessorKey?: string;
	header?: string;
	id?: string;
	enableHiding?: boolean;
	cell?: any;
};

export type TNodes = {
	children?: React.ReactNode;
};

export type TComponentsType = {
	components: React.ReactNode;
};

export type TSearchProps = {
	onChangeHandler?: (props: any) => void;
	value?: string;
	title?: string;
};

export type TIconProps = Partial<Pick<TDashboardTypes, 'Icon'>> & {
	title?: string;
	color?: {
		text: string;
		bg: string;
	};
	dimensions?: {
		height: number;
		width: number;
	};
};

export interface NetworkSubs extends TIconProps {
	network: NetworkLists;
}

export type TBarGraphData = {
	first_fruit: number;
	offerings: number;
	tithe: number;
	name: string;
};

export type TGraphUtilsInterface<TDataType = any> = {
	withAxisLines?: {
		x: boolean;
		y: boolean;
	};
	data?: TDataType;
	title?: string;
} & Pick<TLinegraphReusableComponent, 'xAxisLabel' | 'yAxisLabel'>;

export type TPaginationComponentsType = { currPageSize?: number } & Pick<
	TSearchProps,
	'onChangeHandler'
>;

export interface PieItem {
	id: string;
	name: string;
	value: number;
	bg: string;
}

export interface PieProps {
	data: PieItem[];
	radius?: number;
}

export interface CustomLabelProps {
	cx: number;
	cy: number;
	midAngle: number;
	innerRadius: number;
	outerRadius: number;
	percent: number;
	index: number;
}

export enum IntervalFilterEnum {
	'This Month' = 'This Month',
	'Last Month' = 'Last Month',
	//   "Week" = "Week",
	//   "Day" = "Day",
}

export type TDashboardButtonComponent = {
	width?: string;
	color?: string;
	title: string;
	url?: string;
};

export type ResponseMeta = {
	pagination: {
		pageSize: 25;
		pageCount: 1;
		page: 0;
		total: 0;
	};
};

export interface StrapiResponse<T> {
	meta: ResponseMeta;
	data: T;
}

export type TqueryKey = [
	string,
	{
		options: StrapiRequestParams;
		url: string;
		qFunc: <dataTypeExpected>(params: {
			options: StrapiRequestParams;
			url: string;
		}) => Promise<StrapiResponse<dataTypeExpected>>;
	}
];

export type TStrapiWrapperParams = {
	options: StrapiRequestParams;
	url_last_prt?: string;
	url: string;
};

export type TLinegraphReusableComponent = {
	graphData: TExpenses[];
	yAxisLabel?: string;
	xAxisLabel?: string;
	graphTitle?: string;
	isLoading: boolean;
	isError: boolean;
	title?: string;
};

export enum SortType {
	ASC = 'ASC',
	DESC = 'DESC',
}

export type THeaderBtn = {
	action?: (args: any) => any;
	present: boolean;
	text?: string;
	Icon?: any;
};

export interface TDropDownProps<TData = DropdownData> {
	setFilters: Dispatch<SetStateAction<TFilters>>;
	filters: TFilters;
	data: TData[];
}

export type TTableReusableComponent = {
	filterData: TDropDownProps<TMinistry>;
	onPageChange: (page: number) => void;
	title: string | React.ReactNode;
	columns: ColumnDef<any, any>[];
	ministryFilterTitle: string;
	headerBtn?: THeaderBtn;
	titleFilterInline?: boolean;
	showPagination?: boolean;
	isSearchAtEnd?: boolean;
	searchColumn?: string;
	pagination?: boolean;
	pageCount: number;
	isLoading?: boolean;
	pageSize: number;
	isError?: boolean;
	filter?: boolean;
	sort?: boolean;
	data: any[];
};

export interface DropdownData<LabelType = string> {
	checked: boolean;
	name: LabelType;
}

export type TDropdownHandlerprops = {
	id: number | undefined;
	label: string;
};

export interface TDropdownCustomComponent extends TNodes {
	data: DropdownData[];
	width?: number;
}

export interface StrapiAuthenticationData {
	identifier: string;
	password: string;
}

export type TMinistry = {
	publishedAt: Date;
	createdAt: Date;
	updatedAt: Date;
	name: string;
	icon: Media;
	id: number;
};

export type TUSER<TStaffType = Role> = {
	phone_number: null | string;
	ministry?: TMinistry;
	confirmed: boolean;
	accessType: string;
	gender: null | string;
	firstname: string;
	lastname: string;
	username: string;
	staff_role: TStaffType;
	createdAt: Date;
	updatedAt: Date;
	position?: string;
	blocked: boolean;
	provider: string;
	sub_county: null;
	id_number: null;
	status: string;
	email: string;
	location: null;
	county: null;
	id: number;
};

export type TAuthUser = TUSER;

export type TNetworkType = {
	name: string;
	id: number;
};

export type TTaskType = { time: string; name: string; title: string };

export type TCoordsType = {
	color: string;
	long: number;
	lat: number;
	id: number;
};

export type TCampusLocation = {
	coordinates: TCoordsType;
	location: string;
	name: string;
	id: number;
	network: {
		name: string;
		id: string;
	};
};

export type T = {
	organistion: any;
	networks: any;
	recent: any;
};

export interface TContribution<DType = string> {
	campus: TCampusLocation;
	total: number;
	date: string;
	type: DType;
	id: number;
}

type TSummaryCommon = {
	thisMonth: number;
	lastMonth: number;
	thisWeek: number;
	trend: number;
	count: number;
	today: number;
	total: number;
};

export type TGivingsFilterType = {
	firstfruits: number;
	offering: number;
	tithe: number;
	total: number;
};

export type TOrganizationType = {
	lastMonth: TGivingsFilterType;
	thisMonth: TGivingsFilterType;
	thisWeek: TGivingsFilterType;
	today: TGivingsFilterType;
};

export type TAccountsType = {
	members: Pick<TSummaryCommon, 'total' | 'lastMonth' | 'thisMonth' | 'trend'>;
	recent: TContribution[];
	networks: any[];
	expenses: Pick<
		TSummaryCommon,
		'thisMonth' | 'lastMonth' | 'trend' | 'today' | 'thisWeek'
	>;

	organistion: TOrganizationType;
	giving: Pick<TSummaryCommon, 'total' | 'lastMonth' | 'thisMonth' | 'trend'>;
	campuses: Pick<TSummaryCommon, 'total'>;
	staff: Pick<TSummaryCommon, 'total' | 'thisMonth' | 'trend'>;
	discipleshipGroups: number;
};

export type TPAGE_SIZE_TYPE = {
	onChangeHandler: () => any;
	label: string;
};

export type TComponentBasicProps = {
	styles?: React.CSSProperties;
	svgElementClassName?: string;
	applyToSvgEl?: boolean;
	className?: string;
};

export type TExpenses = {
	month: string;
	count: number;
};

export enum Gender {
	Female = 'Female',
	Male = 'Male',
}

export enum MaritalStatus {
	Married = 'Married',
	Single = 'Single',
}

export type Attendance = {
	month: string;
	total: number;
};

export type TError = {
	message: string;
	status: number;
	details: Details;
	name: string;
};

export type Details = {
	errors: [{ path: string[]; message: string; name: string }];
};

export type SERVER_ERROR = {
	error: TError;
	data: {};
};

export type THttpMethods = 'POST' | 'GET' | 'PUT' | 'PATCH';

export type TCreateEditJobProps = {
	successBtn: {
		subDetails: { method: THttpMethods; url: string };
		text: string;
	};
	titleEnd?: React.ReactNode;
	jobTypes?: TJobTypes[];
	ministries?: TMinistry[];
	closed?: boolean;
	title: string;
	job?: TJob;
};

export type TJobTypes = {
	publishedAt: Date;
	createdAt: Date;
	updatedAt: Date;
	name: string;
	id: number;
};

export enum JobStatusEnum {
	UnderReview = 'under_review',
	Awarded = 'awarded',
	Closed = 'closed',
	Open = 'open',
}

export enum TApplicantStatus {
	UnderReview = 'under_review',
	Shortlisted = 'shortlisted',
	Rejected = 'rejected',
	Awarded = 'awarded',
	New = 'new',
}

export type TCommentType = {
	replies: TCommentType[];
	createdBy: TUSER;
	updatedBy: TUSER;
	createdAt: string;
	updatedAt: string;
	message: string;
	hidden: boolean;
	user: TUSER;
	job: TJob;
};

export type TJob = {
	comments: TCommentType[];
	applications: Application[];
	application_start: string;
	applicationCount: number;
	status: JobStatusEnum;
	application_end: string;
	job_type: TJobTypes;
	ministry: TMinistry;
	description: string;
	publishedAt: string;
	createdAt: string;
	updatedAt: string;
	about_job: string;
	createdBy: any;
	updatedBy: any;
	location: string;
	closedBy: any;
	files: Media[];
	title: string;
	id: number;
};

export interface Application {
	status?: TApplicantStatus;
	publishedAt?: Date;
	comment?: string;
	createdAt: Date;
	updatedAt: Date;
	user?: TUSER;
	files?: Media[];
	job?: TJob;
	id: number;
}

export type TApiHandlerProps = {
	method?: THttpMethods;
	id?: number | string;
	data: any;
	url: string;
};

export type ProfilePropsTypes = {
	onSubmit: any;
	form: any;
};

export interface Role<TIdType = string | number> {
	description: string;
	createdAt: string;
	updatedAt: string;
	nb_users: number;
	id: TIdType;
	name: string;
	type: string;
}

export type TApplicationCountPerMonth = {
	month: string;
	count: number;
};

export type TDashboardData = {
	applications: TApplicationCountPerMonth[];
	shortlistedApplicationsThisMonth: number;
	shortlistedApplicationsLastMonth: number;
	applicationsThisMonth: number;
	applicationsLastMonth: number;
	rejectedApplications: number;
	applicationTrend: number;
	jobsThisMonth: number;
	jobsLastMonth: number;
	shortlistTrend: number;
	jobTrend: number;
};

export type TCardProps = {
	trend: number | undefined;
	thisMonth: number;
	lastMonth: number;
	title: string;
} & Pick<TDashboardTypes, 'Icon'>;

export type TDepartmentCardProps = { title: string; subtitle: string } & Pick<
	TDashboardTypes,
	'Icon'
>;

export type TApplicantFeedback = {
	status?: TApplicantStatus;
	user?: string | number;
	comment?: string;
};

export interface Media {
	id: number;
	alternativeText: string;
	caption: string;
	height: number;
	width: number;
	name: string;
	formats: {
		thumbnail: MediaFormat;
		small: MediaFormat;
		medium: MediaFormat;
		large: MediaFormat;
	};
	previewUrl: string;
	createdAt: Date;
	updatedAt: Date;
	provider: string;
	mime: string;
	size: number;
	hash: string;
	ext: string;
	url: string;
}

export interface MediaFormat {
	height: number;
	width: number;
	name: string;
	size: number;
	mime: string;
	path: string;
	hash: string;
	ext: string;
	url: string;
}

export type FileSelectorPropsType = {
	handleDeleteRemoteItem?: ({ id }: { id: string | number }) => void;
	setSelectedFile: Dispatch<SetStateAction<File[]>>;
	handleDeleteItem?: (file: File) => void;
	selectedFiles: File[];
	jobFiles?: Media[];
};

export type TFilters = { ministries: string[]; term: string };
export interface DropdownDataRadio<LabelType = string> {
	onChangeHandler?: (props: TDropdownHandlerprops) => any;
	id?: string | number;
	label: LabelType;
}

export type TDropdownCustomComponentRadio = {
	onChangeHandler: (value: any) => any;
	currPageSize?: string | number;
	data: DropdownDataRadio[];
	width?: number;
} & TNodes;

export type TReviewStatusProps = {
	handleChange: Dispatch<SetStateAction<TApplicantFeedback>>;
	selectedStatus?: TApplicantStatus;
	handlePrevious: () => void;
	canGoToNext?: boolean;
	savedComment?: string;
	handleNext: () => void;
	comment?: string;
	loading: boolean;
	errMsg: string;
} & Pick<Application, 'status'>;

export enum AddRemoveEnum {
	Remove = 'Remove',
	Add = 'Add',
}

export type TFilterTypes = {
	jobType: JobTypes[] | string[];
	department: string[];
	term: string;
};

export type TAddRemoveFilter = {
	type: TupdateFilterType;
	action?: AddRemoveEnum;
	data: string | JobTypes;
};

export type TupdateFilterType = keyof TFilterTypes;

export type FilterJobsTypes = {
	onChange: ({ type, data, action }: TAddRemoveFilter) => null | void;
	type: TupdateFilterType;
	checked: boolean;
	label: string;
	id?: string;
};

export type FeatureCategoriesTypes = {
	name: string;
} & Pick<TDropDownProps, 'setFilters'>;

interface ActionMapperTypeData<TLabelType = JobOptionsEnum | UserOptionsEnum> {
	label: TLabelType;
}
export interface ActionMapperType<
	TLabelType = JobOptionsEnum | UserOptionsEnum
> {
	onChangeHandler: (data: TDropdownHandlerprops) => void;
	data: ActionMapperTypeData<TLabelType>[];
}

export type ProfileWrapperPropsTypes = {
	data: { data: TUSER<string>; meta: ResponseMeta } | undefined;
	refetch: () => Promise<
		QueryObserverResult<
			{
				data: TUSER<string>;
				meta: ResponseMeta;
			},
			unknown
		>
	>;
};
