import { NumberPrecisionAccronymn } from './components/utils/constants';
import { StrapiResponse, TqueryKey } from './components/utils/types';

export const formatNumbers = (num: number) =>
	NumberPrecisionAccronymn.find((x) => Math.abs(num) >= x.threshold);

export const tickFormatter = (value: any) => {
	const countFormat = formatNumbers(value);

	return countFormat
		? `${(value / countFormat.threshold).toFixed(1) + countFormat.suffix}`
		: value;
};

export const tickFormatterNumberAbsValue = (value: number) =>
	`${value.toLocaleString('en-US')}`;

export const useQueryCustomWrapper = <dataTypeExpected>({
	queryKey,
}: {
	queryKey: any;
}) => {
	const [, { url, options, qFunc }]: TqueryKey = queryKey;

	return qFunc<dataTypeExpected>({
		options,
		url,
	}).then(({ data, meta }: StrapiResponse<dataTypeExpected>) => ({
		data,
		meta,
	}));
};
