import type { Config } from 'tailwindcss';
const { fontFamily } = require('tailwindcss/defaultTheme');

const config: Config = {
	darkMode: 'class',

	content: [
		'./src/pages/**/*.{js,ts,jsx,tsx,mdx}',
		'./src/components/**/*.{js,ts,jsx,tsx,mdx}',
		'./src/app/**/*.{js,ts,jsx,tsx,mdx}',
	],
	theme: {
		extend: {
			container: {
				center: true,
				padding: '2rem',
				screens: {
					'2xl': '1400px',
				},
			},
			boxShadow: {
				networkNameBoxShadow:
					'0px 1px 3px 0px rgba(0, 0, 0, 0.20), 0px 2px 1px 0px rgba(0, 0, 0, 0.12), 0px 1px 1px 0px rgba(0, 0, 0, 0.14)',
				cardBoxShadow:
					'0px 14px 40px -4px #afbecc40, 0px 0px 2px 0px #afbecc40',

				cardBoxShadowDark:
					'0px 2px 4px 0px #00000033, 0px 1px 10px 0px #0000001f,0px 4px 5px 0px #00000024',
				btnBoxShadow: '0px 1px 2px 0px #1018280D',
				applicantBoxDetailsShadow:
					'0px 2px 4px -1px #1A38601A,0px 3px 12px -1px #1C375A29',
				sidebarShadow: '0px 1px 4px -1px #1C345442',
				profileBoxShadow:
					'0px 2px 6px -1px #1A38601A,0px 8px 24px -4px #1C375A29',
				page404Shadow: '0px 2px 6px -1px #1A38601A,0px 8px 24px -4px #1C375A29',
			},

			colors: {
				'fountain-darker': 'var(--foundation-dark-orange-darker-active)',
				'new-applicant-text-color': 'var(--new-applicant-text-color)',
				'job-awarded-text-color': 'var(--job-awarded-text-color)',
				'card-icon-color-light-bg': 'var(--card-icon-color-light-bg)',
				'foundation-dark-orange': 'var(--foundation-dark-orange)',
				'fountain': 'var(--foundation-dark-orange-light-active)',
				'chooseFileIconBgColor': 'var(--chooseFileIconBgColor)',
				'chooseFileTextColor': 'var(--chooseFileTextColor)',
				'new-applicant-color': 'var(--new-applicant-color)',
				'job-closed-text-color': 'var(--job-closed-text-color)',
				'hover-bg-color-btn': 'var(--hover-bg-color-btn)',
				'table-border-color': 'var(--table-border-color)',
				'chooseFileBgColor': 'var(--chooseFileBgColor)',
				'checkMarkColor': 'var(--checkMarkColor)',
				'checkboxColor': 'var(--checkboxColor)',
				'login-screen-text-color': 'var(--login-screen-text-color)',
				'contract-border-color': 'var(--contract-border-color)',
				'job-awarded-bg-color': 'var(--job-awarded-bg-color)',
				'contract-text-color': 'var(--contract-text-color)',
				'job-closed-bg-color': 'var(--job-closed-bg-color)',
				'filter-stroke-color': 'var(--filter-stroke-color)',
				'attachment-border': 'var(--attachment-border)',
				'applicant-colorbg': 'var(--applicant-color)',
				'search-icon-color': 'var(--search-icon-color)',
				'sidebar-bg-light': 'var(--light-mode-sidebar-bg)',
				'table-title-color': 'var(--table-title-color)',
				'applicant-colorText': 'var(--applicant-colorText)',
				'table-bg-color': 'var(--table-bg-color)',
				'navy-tab-color': 'var(--navy-tab-color)',
				'delete-btn': 'var(--delete-btn-color)',
				'time-color': 'var(--time-color)',
				'border-color': 'var(--border-color)',
				'gray-border': 'var(--gray-border)',
				'trend-up': 'var(--info-trend-color)',
				'name-color': 'var(--name-color)',
				'tag-color': 'var(--tag-color)',
				'some-gray': 'var(----some-gray)',
				'dark-green': 'var(--dark-green)',
				'dark-orange': 'var(--dark-orange)',
				'foundation': 'var(--foundation)',
				'tick-color': 'var(--tick-color)',
				'btn-orange': 'var(--btn-orange)',
				'dots-color': 'var(--dots-color)',
				'tab-color': 'var(--tab-color)',
				'sidebar-bg': 'var(--sidebar-bg)',
				'red-error': 'var(--red-error)',
				'error-bg': 'var(--error-bg)',
				'body-bg': 'var(--body-bg)',
				'lightdark': '#0C0A096',
				'navy': 'var(--navy)',
				'small-card-bg-light': 'var(--small-card-bg-light)',
				'dark-body-text': 'var(--dark-body-text)',
				'main-orange': 'var(--main-orange)',
				'small-card-bg': 'var(--small-card-bg)',
				'red-table-light': 'var(--red-table-light)',
				'green-table-light': 'var(--green-table-light)',
				'body': 'var(--body-bg)',
				'fol': 'var(--foundation-orange-light)',
				'fol-hover': 'var(--foundation-orange-light-hover)',
				'fol-active': 'var(--foundation-orange-light-active)',
				'fon': 'var(--foundation-orange-normal)',
				'fon-hover': 'var(--foundation-orange-normal-hover)',
				'fon-active': 'var(--foundation-orange-normal-active)',
				'fod': 'var(--foundation-orange-dark)',
				'fod-hover': 'var(--foundation-orange-dark-hover)',
				'fod-active': 'var(--foundation-orange-dark-active)',
				'fwl': 'var(--foundation-white-light)',
				'fwl-hover': 'var(--foundation-white-light-hover)',
				'fwl-active': 'var(--foundation-white-light-active)',
				'fwn': 'var(--foundation-white-normal)',
				'fwn-hover': 'var(--foundation-white-normal-hover)',
				'fwn-active': 'var(--foundation-white-normal-active)',
				'fwd': 'var(--foundation-white-dark)',
				'fwd-hover': 'var(--foundation-white-dark-hover)',
				'fwd-active': 'var(--foundation-white-dark-active)',
				'fwd-darker': 'var(--table-record-hover-bg)',
				'fd-black': 'var(--foundation-dark-black)',
				'fd-normal': 'var(--foundation-dark-normal)',
				'fd-normal-hover': 'var(--foundation-dark-normal-hover)',
				'fd-normal-active': 'var(--foundation-dark-normal-active)',
				'fd-dark-hover': 'var(--foundation-dark-dark-hover)',
				'body-text-gray-500': 'var(--body-text-gray-500)',
				'fongreen-normal': 'var(--fongreen-normal)',
				'title-text-color': 'var(--title-text-color)',
				'border-color-btn': 'var(--border-color)',
				'gray-body-text': 'var(--gray-body-text)',
				'fd-dark': 'var(--foundation-dark-dark)',
				'brown-border': 'var(--brown-border)',
				'normal-hover': 'var(--normal-hover)',
				'brown-text': 'var(--brown-text)',
				'green-text': 'var(--green-text)',
				'deep-purple': 'var(--deep-purple)',
				'light-purple': 'var(--light-purple)',
				//renamed  from  accent
				'dev-accent': 'var(--accent-color)',

				// Colors From Shad Cn
				'border': 'hsl(var(--border))',
				'input': 'hsl(var(--input))',
				'ring': 'hsl(var(--ring))',
				'background': 'hsl(var(--background))',
				'foreground': 'hsl(var(--foreground))',
				'primary': {
					DEFAULT: 'hsl(var(--primary))',
					foreground: 'hsl(var(--primary-foreground))',
				},
				'secondary': {
					DEFAULT: 'hsl(var(--secondary))',
					foreground: 'hsl(var(--secondary-foreground))',
				},
				'destructive': {
					DEFAULT: 'hsl(var(--destructive))',
					foreground: 'hsl(var(--destructive-foreground))',
				},
				'muted': {
					DEFAULT: 'hsl(var(--muted))',
					foreground: 'hsl(var(--muted-foreground))',
				},
				'accent': {
					DEFAULT: 'hsl(var(--accent))',
					foreground: 'hsl(var(--accent-foreground))',
				},
				'popover': {
					DEFAULT: 'hsl(var(--popover))',
					foreground: 'hsl(var(--popover-foreground))',
				},
				'card': {
					DEFAULT: 'hsl(var(--card))',
					foreground: 'hsl(var(--card-foreground))',
				},
			},

			backgroundImage: {
				'gradient-radial': 'radial-gradient(var(--tw-gradient-stops))',
				'gradient-conic':
					'conic-gradient(from 180deg at 50% 50%, var(--tw-gradient-stops))',
				// levi
				'login-image': "url('/login.png')",
			},
			borderRadius: {
				lg: `var(--radius)`,
				md: `calc(var(--radius) - 2px)`,
				sm: 'calc(var(--radius) - 4px)',
			},
			fontFamily: {
				sans: ['Lato', ...fontFamily.sans],
			},
			keyframes: {
				'accordion-down': {
					from: { height: '0' },
					to: { height: 'var(--radix-accordion-content-height)' },
				},
				'accordion-up': {
					from: { height: 'var(--radix-accordion-content-height)' },
					to: { height: '0' },
				},
			},
			animation: {
				'accordion-down': 'accordion-down 0.2s ease-out',
				'accordion-up': 'accordion-up 0.2s ease-out',
			},
		},
	},
	plugins: [],
};
export default config;
